/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.util.OptionsFileUtil;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.sqoop.SqoopVersion;

public class Sqoop
extends Configured
implements Tool {
    public static final Log SQOOP_LOG = LogFactory.getLog((String)"com.cloudera.sqoop");
    public static final Log LOG = LogFactory.getLog((String)Sqoop.class.getName());
    public static final String SQOOP_RETHROW_PROPERTY = "sqoop.throwOnError";
    public static final String SQOOP_OPTIONS_FILE_SPECIFIER = "--options-file";
    private SqoopTool tool;
    private SqoopOptions options;
    private String[] childPrgmArgs;

    public Sqoop(SqoopTool tool) {
        this(tool, null);
    }

    public Sqoop(SqoopTool tool, Configuration conf) {
        this(tool, conf, new SqoopOptions());
    }

    public Sqoop(SqoopTool tool, Configuration conf, SqoopOptions opts) {
        new SqoopVersion();
        LOG.info((Object)("Running Sqoop version: " + "1.4.4-cdh5.1.2"));
        if (null != conf) {
            this.setConf(conf);
        }
        this.options = opts;
        this.options.setConf(this.getConf());
        this.tool = tool;
    }

    public SqoopOptions getOptions() {
        return this.options;
    }

    public SqoopTool getTool() {
        return this.tool;
    }

    public int run(String[] args) {
        if (this.options.getConf() == null) {
            this.options.setConf(this.getConf());
        }
        try {
            this.options = this.tool.parseArguments(args, null, this.options, false);
            this.tool.appendArgs(this.childPrgmArgs);
            this.tool.validateOptions(this.options);
        }
        catch (Exception e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            System.err.println(e.getMessage());
            ToolOptions toolOpts = new ToolOptions();
            this.tool.configureOptions(toolOpts);
            this.tool.printHelp(toolOpts);
            return 1;
        }
        return this.tool.run(this.options);
    }

    private String[] stashChildPrgmArgs(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            if (!"--".equals(argv[i])) continue;
            this.childPrgmArgs = Arrays.copyOfRange(argv, i, argv.length);
            return Arrays.copyOfRange(argv, 0, i);
        }
        return argv;
    }

    public static int runSqoop(Sqoop sqoop, String[] args) {
        try {
            String[] toolArgs = sqoop.stashChildPrgmArgs(args);
            return ToolRunner.run((Configuration)sqoop.getConf(), (Tool)sqoop, (String[])toolArgs);
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop: " + e.toString()));
            e.printStackTrace();
            if (System.getProperty(SQOOP_RETHROW_PROPERTY) != null) {
                throw new RuntimeException(e);
            }
            return 1;
        }
    }

    public static int runTool(String[] args, Configuration conf) {
        String[] expandedArgs = null;
        try {
            expandedArgs = OptionsFileUtil.expandArguments(args);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while expanding arguments", (Throwable)ex);
            System.err.println(ex.getMessage());
            System.err.println("Try 'sqoop help' for usage.");
            return 1;
        }
        String toolName = expandedArgs[0];
        Configuration pluginConf = SqoopTool.loadPlugins(conf);
        SqoopTool tool = SqoopTool.getTool(toolName);
        if (null == tool) {
            System.err.println("No such sqoop tool: " + toolName + ". See 'sqoop help'.");
            return 1;
        }
        Sqoop sqoop = new Sqoop(tool, pluginConf);
        return Sqoop.runSqoop(sqoop, Arrays.copyOfRange(expandedArgs, 1, expandedArgs.length));
    }

    public static int runTool(String[] args) {
        return Sqoop.runTool(args, new Configuration());
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Try 'sqoop help' for usage.");
            System.exit(1);
        }
        int ret = Sqoop.runTool(args);
        System.exit(ret);
    }

    static {
        Configuration.addDefaultResource((String)"sqoop-site.xml");
    }
}

