/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.hcat;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.SqoopMapper;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatImportHelper;

public class SqoopHCatImportMapper
extends SqoopMapper<WritableComparable, SqoopRecord, WritableComparable, HCatRecord> {
    public static final Log LOG = LogFactory.getLog((String)SqoopHCatImportMapper.class.getName());
    private SqoopHCatImportHelper helper;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.helper = new SqoopHCatImportHelper(conf);
    }

    public void map(WritableComparable key, SqoopRecord value, Mapper.Context context) throws IOException, InterruptedException {
        context.write((Object)key, (Object)this.helper.convertToHCatRecord(value));
    }

    protected void cleanup(Mapper.Context context) throws IOException {
        this.helper.cleanup();
    }
}

