/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ImportJobContext;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class AppendUtils {
    public static final Log LOG = LogFactory.getLog((String)AppendUtils.class.getName());
    private static final SimpleDateFormat DATE_FORM = new SimpleDateFormat("ddHHmmssSSSSSSSSS");
    private static final String TEMP_IMPORT_ROOT = System.getProperty("sqoop.test.import.rootDir", "_sqoop");
    private static final int PARTITION_DIGITS = 5;
    private static final String FILEPART_SEPARATOR = "-";
    private static final String FILEEXT_SEPARATOR = ".";
    private static final Pattern DATA_PART_PATTERN = Pattern.compile("part.*-([0-9]{5}+).*");
    private ImportJobContext context = null;

    public AppendUtils(ImportJobContext context) {
        this.context = context;
    }

    public void append() throws IOException {
        SqoopOptions options = this.context.getOptions();
        Path tempDir = this.context.getDestination();
        Path userDestDir = null;
        userDestDir = options.getTargetDir() != null ? new Path(options.getTargetDir()) : (options.getWarehouseDir() != null ? new Path(options.getWarehouseDir(), this.context.getTableName()) : new Path(this.context.getTableName()));
        FileSystem fs = userDestDir.getFileSystem(options.getConf());
        int nextPartition = 0;
        if (!fs.exists(tempDir)) {
            LOG.warn((Object)("Cannot append files to target dir; no such directory: " + tempDir));
            return;
        }
        if (!fs.exists(userDestDir)) {
            LOG.info((Object)("Creating missing output directory - " + userDestDir.getName()));
            fs.mkdirs(userDestDir);
            nextPartition = 0;
        } else {
            LOG.info((Object)("Appending to directory " + userDestDir.getName()));
            nextPartition = this.getNextPartition(fs, userDestDir);
        }
        this.moveFiles(fs, tempDir, userDestDir, nextPartition);
        LOG.debug((Object)("Deleting temporary folder " + tempDir.getName()));
        fs.delete(tempDir, true);
    }

    private int getNextPartition(FileSystem fs, Path targetDir) throws IOException {
        int nextPartition = 0;
        FileStatus[] existingFiles = fs.listStatus(targetDir);
        if (existingFiles != null && existingFiles.length > 0) {
            for (FileStatus fileStat : existingFiles) {
                int thisPart;
                String filename;
                Matcher mat;
                if (fileStat.isDir() || !(mat = DATA_PART_PATTERN.matcher(filename = fileStat.getPath().getName())).matches() || (thisPart = Integer.parseInt(mat.group(1))) < nextPartition) continue;
                nextPartition = thisPart;
                ++nextPartition;
            }
        }
        if (nextPartition > 0) {
            LOG.info((Object)("Using found partition " + nextPartition));
        }
        return nextPartition;
    }

    private void moveFiles(FileSystem fs, Path sourceDir, Path targetDir, int partitionStart) throws IOException {
        FileStatus[] sourceFiles = fs.listStatus(sourceDir);
        if (null == sourceFiles) {
            throw new IOException("Could not list files from " + sourceDir);
        }
        NumberFormat partFormat = NumberFormat.getInstance();
        partFormat.setMinimumIntegerDigits(5);
        partFormat.setGroupingUsed(false);
        int dataPart = partitionStart;
        for (FileStatus fileStatus : sourceFiles) {
            String sourceFilename = fileStatus.getPath().getName();
            StringBuilder destFilename = new StringBuilder();
            if (fileStatus.isDir()) {
                Path destPath;
                if (fs.rename(fileStatus.getPath(), targetDir)) {
                    LOG.debug((Object)("Directory: " + sourceFilename + " renamed to: " + sourceFilename));
                    continue;
                }
                int dirNumber = 0;
                do {
                    destFilename.setLength(0);
                    destFilename.append(sourceFilename).append(FILEPART_SEPARATOR).append(partFormat.format(dirNumber++));
                    destPath = new Path(targetDir, destFilename.toString());
                    if (!fs.exists(destPath)) continue;
                } while (!fs.rename(fileStatus.getPath(), destPath));
                LOG.debug((Object)("Directory: " + sourceFilename + " renamed to: " + destPath.getName()));
                continue;
            }
            if (DATA_PART_PATTERN.matcher(sourceFilename).matches()) {
                do {
                    destFilename.setLength(0);
                    destFilename.append(this.getFilename(sourceFilename)).append(partFormat.format(dataPart++));
                    String extension = this.getFileExtension(sourceFilename);
                    if (extension == null) continue;
                    destFilename.append(this.getFileExtension(sourceFilename));
                } while (!fs.rename(fileStatus.getPath(), new Path(targetDir, destFilename.toString())));
                LOG.debug((Object)("Filename: " + sourceFilename + " repartitioned to: " + destFilename.toString()));
                continue;
            }
            LOG.debug((Object)("Filename: " + sourceFilename + " ignored"));
        }
    }

    private String getFilename(String filename) {
        String result = null;
        int pos = filename.lastIndexOf(FILEPART_SEPARATOR);
        result = pos != -1 ? filename.substring(0, pos + 1) : ((pos = filename.lastIndexOf(FILEEXT_SEPARATOR)) != -1 ? filename.substring(0, pos) : filename);
        return result;
    }

    private String getFileExtension(String filename) {
        int pos = filename.lastIndexOf(FILEEXT_SEPARATOR);
        if (pos != -1) {
            return filename.substring(pos, filename.length());
        }
        return null;
    }

    public static Path getTempAppendDir(String salt) {
        String timeId = DATE_FORM.format(new Date(System.currentTimeMillis()));
        String jvmName = ManagementFactory.getRuntimeMXBean().getName().replaceAll("@", "_");
        String tempDir = TEMP_IMPORT_ROOT + "/" + timeId + "_" + jvmName + "_" + salt;
        return new Path(tempDir);
    }
}

