/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DBInputFormat;
import com.cloudera.sqoop.mapreduce.db.DataDrivenDBRecordReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.manager.oracle.OraOopConstants;
import org.apache.sqoop.manager.oracle.OraOopDBInputSplit;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopOracleDataChunk;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopUtilities;
import org.apache.sqoop.manager.oracle.OracleConnectionFactory;
import org.apache.sqoop.manager.oracle.OracleTable;
import org.apache.sqoop.manager.oracle.OracleTableColumn;
import org.apache.sqoop.manager.oracle.OracleTableColumns;

class OraOopDBRecordReader<T extends SqoopRecord>
extends DataDrivenDBRecordReader<T> {
    private static final OraOopLog LOG = OraOopLogFactory.getLog(OraOopDBRecordReader.class);
    private OraOopDBInputSplit dbInputSplit;
    private int numberOfBlocksInThisSplit;
    private int numberOfBlocksProcessedInThisSplit;
    private String currentDataChunkId;
    private ResultSet results;
    private int columnIndexDataChunkIdZeroBased = -1;
    private boolean progressCalculationErrorLogged;
    private Object oraOopOraStats;
    private boolean profilingEnabled;
    private long timeSpentInNextKeyValueInNanoSeconds;

    public OraOopDBRecordReader(DBInputFormat.DBInputSplit split, Class<T> inputClass, Configuration conf, Connection conn, DBConfiguration dbConfig, String cond, String[] fields, String table) throws SQLException {
        super(split, inputClass, conf, conn, dbConfig, cond, fields, table, "ORACLE-ORAOOP");
        OraOopUtilities.enableDebugLoggingIfRequired(conf);
        this.dbInputSplit = OraOopDBRecordReader.castSplit(split);
        String thisOracleInstanceName = OraOopOracleQueries.getCurrentOracleInstanceName(conn);
        LOG.info(String.format("This record reader is connected to Oracle via the JDBC URL: \n\t\"%s\"\n\tto the Oracle instance: \"%s\"", conn.toString(), thisOracleInstanceName));
        OracleConnectionFactory.initializeOracleConnection(conn, conf);
        if (OraOopUtilities.userWantsOracleSessionStatisticsReports(conf)) {
            this.oraOopOraStats = OraOopUtilities.startSessionSnapshot(conn);
        }
        this.numberOfBlocksInThisSplit = this.dbInputSplit.getTotalNumberOfBlocksInThisSplit();
        this.numberOfBlocksProcessedInThisSplit = 0;
        this.profilingEnabled = conf.getBoolean("oraoop.profiling.enabled", false);
    }

    public static OraOopDBInputSplit castSplit(DBInputFormat.DBInputSplit split) {
        if (split == null) {
            throw new IllegalArgumentException("The DBInputSplit cannot be null.");
        }
        Class<OraOopDBInputSplit> desiredSplitClass = OraOopDBInputSplit.class;
        if (((Object)((Object)split)).getClass() != desiredSplitClass) {
            String errMsg = String.format("The type of Split available within %s should be an instance of class %s, but is actually an instance of class %s", OraOopUtilities.getCurrentMethodName(), desiredSplitClass.getName(), ((Object)((Object)split)).getClass().getName());
            throw new RuntimeException(errMsg);
        }
        return (OraOopDBInputSplit)split;
    }

    @Override
    protected String[] getFieldNames() {
        String[] fieldNames = super.getFieldNames();
        ArrayList<String> result = new ArrayList<String>();
        for (int idx = 0; idx < fieldNames.length; ++idx) {
            result.add(fieldNames[idx]);
        }
        result.add("data_chunk_id");
        this.columnIndexDataChunkIdZeroBased = result.size() - 1;
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected String getSelectQuery() {
        String conditions;
        boolean consistentRead = this.getDBConf().getConf().getBoolean("oraoop.import.consistent.read", false);
        long consistentReadScn = this.getDBConf().getConf().getLong("oraoop.import.consistent.read.scn", 0L);
        if (consistentRead && consistentReadScn == 0L) {
            throw new RuntimeException("Could not get SCN for consistent read.");
        }
        StringBuilder query = new StringBuilder();
        if (this.dbInputSplit.getDataChunks() == null) {
            String errMsg = String.format("The %s does not contain any data-chunks, within %s.", ((Object)((Object)this.dbInputSplit)).getClass().getName(), OraOopUtilities.getCurrentMethodName());
            throw new RuntimeException(errMsg);
        }
        OraOopConstants.OraOopTableImportWhereClauseLocation whereClauseLocation = OraOopUtilities.getOraOopTableImportWhereClauseLocation(this.getDBConf().getConf(), OraOopConstants.OraOopTableImportWhereClauseLocation.SUBSPLIT);
        OracleTable tableContext = this.getOracleTableContext();
        OracleTableColumns tableColumns = null;
        try {
            Configuration conf = this.getDBConf().getConf();
            tableColumns = OraOopOracleQueries.getTableColumns(this.getConnection(), tableContext, OraOopUtilities.omitLobAndLongColumnsDuringImport(conf), OraOopUtilities.recallSqoopJobType(conf), true, true);
        }
        catch (SQLException ex) {
            LOG.error(String.format("Unable to obtain the data-types of the columns in table %s.\nError:\n%s", tableContext.toString(), ex.getMessage()));
            throw new RuntimeException(ex);
        }
        int numberOfDataChunks = this.dbInputSplit.getNumberOfDataChunks();
        for (int idx = 0; idx < numberOfDataChunks; ++idx) {
            String conditions2;
            OraOopOracleDataChunk dataChunk = this.dbInputSplit.getDataChunks().get(idx);
            if (idx > 0) {
                query.append("UNION ALL \n");
            }
            query.append(this.getColumnNamesClause(tableColumns, dataChunk.getId())).append("\n");
            query.append(" FROM ").append(this.getTableName()).append(" ");
            if (consistentRead) {
                query.append("AS OF SCN ").append(consistentReadScn).append(" ");
            }
            query.append(this.getPartitionClauseForDataChunk(this.dbInputSplit, idx)).append(" t").append("\n");
            query.append(" WHERE (").append(this.getWhereClauseForDataChunk(this.dbInputSplit, idx)).append(")\n");
            if (whereClauseLocation != OraOopConstants.OraOopTableImportWhereClauseLocation.SUBSPLIT || (conditions2 = this.getConditions()) == null || conditions2.length() <= 0) continue;
            query.append(" AND (").append(conditions2).append(")\n");
        }
        if (whereClauseLocation == OraOopConstants.OraOopTableImportWhereClauseLocation.SPLIT && (conditions = this.getConditions()) != null && conditions.length() > 0) {
            query.insert(0, this.getColumnNamesClause(tableColumns, null) + " FROM (\n");
            query.append(")\n").append("WHERE\n").append(conditions).append("\n");
        }
        LOG.info("SELECT QUERY = \n" + query.toString());
        return query.toString();
    }

    private String getColumnNamesClause(OracleTableColumns tableColumns, String dataChunkId) {
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        result.append(OraOopUtilities.getImportHint(this.getDBConf().getConf()));
        String[] fieldNames = this.getFieldNames();
        int firstFieldIndex = 0;
        int lastFieldIndex = fieldNames.length - 1;
        for (int i = firstFieldIndex; i <= lastFieldIndex; ++i) {
            String fieldName;
            OracleTableColumn oracleTableColumn;
            if (i > firstFieldIndex) {
                result.append(",");
            }
            if ((oracleTableColumn = tableColumns.findColumnByName(fieldName = fieldNames[i])) != null && oracleTableColumn.getDataType().equals("URITYPE")) {
                fieldName = String.format("uritype.geturl(%s)", fieldName);
            }
            if (i == this.columnIndexDataChunkIdZeroBased && fieldName == "data_chunk_id" && dataChunkId != null && !dataChunkId.isEmpty()) {
                fieldName = String.format("'%s' %s", dataChunkId, "data_chunk_id");
            }
            result.append(fieldName);
        }
        return result.toString();
    }

    private String getPartitionClauseForDataChunk(OraOopDBInputSplit split, int dataChunkIndex) {
        OraOopOracleDataChunk dataChunk = split.getDataChunks().get(dataChunkIndex);
        return dataChunk.getPartitionClause();
    }

    private String getWhereClauseForDataChunk(OraOopDBInputSplit split, int dataChunkIndex) {
        OraOopOracleDataChunk dataChunk = split.getDataChunks().get(dataChunkIndex);
        return dataChunk.getWhereClause();
    }

    @Override
    public long getPos() throws IOException {
        return this.numberOfBlocksProcessedInThisSplit;
    }

    @Override
    public float getProgress() throws IOException {
        return (float)this.numberOfBlocksProcessedInThisSplit / (float)this.numberOfBlocksInThisSplit;
    }

    @Override
    public boolean nextKeyValue() throws IOException {
        boolean result;
        block9: {
            result = false;
            try {
                String thisDataChunkId;
                block10: {
                    long startTime = 0L;
                    if (this.profilingEnabled) {
                        startTime = System.nanoTime();
                    }
                    result = super.nextKeyValue();
                    if (this.profilingEnabled) {
                        this.timeSpentInNextKeyValueInNanoSeconds += System.nanoTime() - startTime;
                    }
                    if (!result || this.results == null) break block9;
                    thisDataChunkId = null;
                    try {
                        thisDataChunkId = this.results.getString(this.columnIndexDataChunkIdZeroBased + 1);
                    }
                    catch (SQLException ex) {
                        if (this.progressCalculationErrorLogged) break block10;
                        this.progressCalculationErrorLogged = true;
                        LOG.warn(String.format("Unable to obtain the value of the %s column in method %s.\n\tthis.columnIndexDataChunkIdZeroBased = %d (NB: jdbc field indexes are 1-based)\n\tAs a consequence, progress for the record-reader cannot be calculated.\n\tError=\n%s", "data_chunk_id", OraOopUtilities.getCurrentMethodName(), this.columnIndexDataChunkIdZeroBased, ex.getMessage()));
                    }
                }
                if (thisDataChunkId != null && !thisDataChunkId.equals(this.currentDataChunkId)) {
                    OraOopOracleDataChunk dataChunk;
                    if (this.currentDataChunkId != null && !this.currentDataChunkId.isEmpty() && (dataChunk = this.dbInputSplit.findDataChunkById(thisDataChunkId)) != null) {
                        this.numberOfBlocksProcessedInThisSplit += dataChunk.getNumberOfBlocks();
                    }
                    this.currentDataChunkId = thisDataChunkId;
                }
            }
            catch (IOException ex) {
                if (OraOopUtilities.oracleSessionHasBeenKilled(ex)) {
                    LOG.info("\n*********************************************************\nThe Oracle session in use has been killed by a 3rd party.\n*********************************************************");
                }
                throw ex;
            }
        }
        return result;
    }

    @Override
    protected ResultSet executeQuery(String query) throws SQLException {
        try {
            this.results = super.executeQuery(query);
            return this.results;
        }
        catch (SQLException ex) {
            LOG.error(String.format("Error in %s while executing the SQL query:\n%s\n\n%s", OraOopUtilities.getCurrentMethodName(), query, ex.getMessage()));
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.profilingEnabled) {
            LOG.info(String.format("Time spent in super.nextKeyValue() = %s seconds.", (double)this.timeSpentInNextKeyValueInNanoSeconds / Math.pow(10.0, 9.0)));
        }
        if (OraOopUtilities.userWantsOracleSessionStatisticsReports(this.getDBConf().getConf())) {
            OraOopUtilities.OraOopStatsReports reports = OraOopUtilities.stopSessionSnapshot(this.oraOopOraStats);
            this.oraOopOraStats = null;
            LOG.info(String.format("Oracle Statistics Report for OraOop:\n\n%s", reports.getPerformanceReport()));
            String fileName = String.format("oracle-stats-csv-%d", this.dbInputSplit.getSplitId());
            OraOopUtilities.writeOutputFile(this.getDBConf().getConf(), fileName, reports.getCsvReport());
            fileName = String.format("oracle-stats-%d", this.dbInputSplit.getSplitId());
            OraOopUtilities.writeOutputFile(this.getDBConf().getConf(), fileName, reports.getPerformanceReport());
        }
        super.close();
    }

    public OracleTable getOracleTableContext() {
        Configuration conf = this.getDBConf().getConf();
        OracleTable result = new OracleTable(conf.get("oraoop.table.owner"), conf.get("oraoop.table.name"));
        return result;
    }
}

