/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.mapreduce.db.SQLFailureHandler;

public class BasicRetrySQLFailureHandler
extends SQLFailureHandler {
    private static final Log LOG = LogFactory.getLog(BasicRetrySQLFailureHandler.class);
    public static final String CONNECTION_RETRY_WAIT_MAX = "connection.recover.wait.max";
    public static final String CONNECTION_RETRY_WAIT_INTERVAL = "connection.recover.wait.interval";
    public static final int DEFAULT_RETRY_WAIT_MAX = 120000;
    public static final int DEFAULT_RETRY_WAIT_INTERVAL = 500;
    protected int retryWaitMax = 0;
    protected int retryWaitInterval = 0;

    @Override
    public void initialize(Configuration conf) throws IOException {
        super.initialize(conf);
        this.retryWaitMax = conf.getInt(CONNECTION_RETRY_WAIT_MAX, 120000);
        this.retryWaitInterval = conf.getInt(CONNECTION_RETRY_WAIT_INTERVAL, 500);
        if (this.retryWaitMax <= this.retryWaitInterval || this.retryWaitInterval <= 0) {
            LOG.error((Object)"Failed to initialize handler");
            throw new IOException("Invalid retry paramers. Wait Max:  " + this.retryWaitMax + ". wait interval: " + this.retryWaitInterval);
        }
        LOG.trace((Object)"Retry Handler initialized successfully");
    }

    @Override
    public boolean canHandleFailure(Throwable failureCause) {
        return failureCause != null && SQLException.class.isAssignableFrom(failureCause.getClass());
    }

    @Override
    public Connection recover() throws IOException {
        long nextRetryWait = 0L;
        int retryAttempts = 0;
        boolean doRetry = true;
        boolean validConnection = false;
        Connection conn = null;
        do {
            validConnection = false;
            nextRetryWait = (long)Math.pow(retryAttempts, 2.0) * (long)this.retryWaitInterval;
            ++retryAttempts;
            if (nextRetryWait > (long)this.retryWaitMax) {
                nextRetryWait = this.retryWaitMax;
                doRetry = false;
            }
            try {
                Thread.sleep(nextRetryWait);
                this.discardConnection(conn);
                conn = super.getConnection();
                if (!this.validateConnection(conn)) {
                    LOG.warn((Object)"Connection not valid");
                    continue;
                }
                LOG.info((Object)"A new connection has been established");
                doRetry = false;
                validConnection = true;
            }
            catch (SQLException sqlEx) {
                LOG.warn((Object)("Connection recovery attempt [" + retryAttempts + "] failed." + "Exception details: " + sqlEx.toString()));
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed while recovering the connection. Exception details:" + ex.toString()));
                throw new IOException(ex);
            }
        } while (doRetry);
        if (!validConnection) {
            throw new IOException("Failed to recover connection after " + retryAttempts + " retries. Giving up");
        }
        return conn;
    }

    protected boolean validateConnection(Connection connection) throws SQLException {
        return connection != null && !connection.isClosed() && connection.isValid(500);
    }

    protected void discardConnection(Connection connection) throws IOException {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sqlEx) {
            LOG.warn((Object)("Could not close connection. Exception details: " + sqlEx));
        }
    }
}

