/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hive;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.util.ExitSecurityException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.sqoop.hive.TableDefWriter;
import org.apache.sqoop.io.CodecMap;
import org.apache.sqoop.util.Executor;
import org.apache.sqoop.util.LoggingAsyncSink;
import org.apache.sqoop.util.SubprocessSecurityManager;

public class HiveImport {
    public static final Log LOG = LogFactory.getLog((String)HiveImport.class.getName());
    private SqoopOptions options;
    private ConnManager connManager;
    private Configuration configuration;
    private boolean generateOnly;
    private static boolean testMode = false;
    private static final String HIVE_MAIN_CLASS = "org.apache.hadoop.hive.cli.CliDriver";

    public static boolean getTestMode() {
        return testMode;
    }

    public static void setTestMode(boolean mode) {
        testMode = mode;
    }

    public HiveImport(SqoopOptions opts, ConnManager connMgr, Configuration conf, boolean generateOnly) {
        this.options = opts;
        this.connManager = connMgr;
        this.configuration = conf;
        this.generateOnly = generateOnly;
    }

    private String getHiveBinPath() {
        String hiveCommand;
        String hiveHome = this.options.getHiveHome();
        String string = hiveCommand = Shell.WINDOWS ? "hive.cmd" : "hive";
        if (null == hiveHome) {
            return hiveCommand;
        }
        Path p = new Path(hiveHome);
        p = new Path(p, "bin");
        String hiveBinStr = (p = new Path(p, hiveCommand)).toString();
        if (new File(hiveBinStr).exists()) {
            return hiveBinStr;
        }
        return hiveCommand;
    }

    private void removeTempLogs(Path tablePath) throws IOException {
        Path logsPath;
        FileSystem fs = FileSystem.get((Configuration)this.configuration);
        if (fs.exists(logsPath = new Path(tablePath, "_logs"))) {
            LOG.info((Object)("Removing temporary files from import process: " + logsPath));
            if (!fs.delete(logsPath, true)) {
                LOG.warn((Object)"Could not delete temporary files; continuing with import, but it may fail.");
            }
        }
    }

    private boolean isGenerateOnly() {
        return this.generateOnly;
    }

    private File getScriptFile(String outputTableName) throws IOException {
        if (!this.isGenerateOnly()) {
            return File.createTempFile("hive-script-", ".txt", new File(this.options.getTempDir()));
        }
        return new File(new File(this.options.getCodeOutputDir()), outputTableName + ".q");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTable(String inputTableName, String outputTableName, boolean createOnly) throws IOException {
        boolean debugMode;
        if (null == outputTableName) {
            outputTableName = inputTableName;
        }
        LOG.debug((Object)("Hive.inputTable: " + inputTableName));
        LOG.debug((Object)("Hive.outputTable: " + outputTableName));
        String expectedScript = System.getProperty("expected.script");
        List<String> env = Executor.getCurEnvpStrings();
        boolean bl = debugMode = expectedScript != null;
        if (debugMode) {
            env.add("EXPECTED_SCRIPT=" + expectedScript);
            env.add("TMPDIR=" + this.options.getTempDir());
        }
        this.connManager.discardConnection(true);
        TableDefWriter tableWriter = new TableDefWriter(this.options, this.connManager, inputTableName, outputTableName, this.configuration, !debugMode);
        String createTableStr = tableWriter.getCreateTableStmt() + ";\n";
        String loadDataStmtStr = tableWriter.getLoadDataStmt() + ";\n";
        String computeStatsStmtStr = tableWriter.getComputeStatsStmt();
        Path finalPath = tableWriter.getFinalPath();
        if (!this.isGenerateOnly()) {
            this.removeTempLogs(finalPath);
            LOG.info((Object)"Loading uploaded data into Hive");
            String codec = this.options.getCompressionCodec();
            if (codec != null && (codec.equals("lzop") || codec.equals(CodecMap.getCodecClassName("lzop")))) {
                try {
                    Tool tool = (Tool)ReflectionUtils.newInstance(Class.forName("com.hadoop.compression.lzo.DistributedLzoIndexer").asSubclass(Tool.class), (Configuration)this.configuration);
                    ToolRunner.run((Configuration)this.configuration, (Tool)tool, (String[])new String[]{finalPath.toString()});
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error indexing lzo files", (Throwable)ex);
                    throw new IOException("Error indexing lzo files", ex);
                }
            }
        }
        File scriptFile = this.getScriptFile(outputTableName);
        try {
            String filename = scriptFile.toString();
            BufferedWriter w = null;
            try {
                FileOutputStream fos = new FileOutputStream(scriptFile);
                w = new BufferedWriter(new OutputStreamWriter(fos));
                w.write(createTableStr, 0, createTableStr.length());
                if (!createOnly) {
                    w.write(loadDataStmtStr, 0, loadDataStmtStr.length());
                    if (computeStatsStmtStr != null) {
                        computeStatsStmtStr = computeStatsStmtStr + ";\n";
                        w.write(computeStatsStmtStr, 0, computeStatsStmtStr.length());
                    }
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)("Error writing Hive load-in script: " + ioe.toString()));
                ioe.printStackTrace();
                throw ioe;
            }
            finally {
                if (null != w) {
                    try {
                        w.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("IOException closing stream to Hive script: " + ioe.toString()));
                    }
                }
            }
            if (!this.isGenerateOnly()) {
                this.executeScript(filename, env);
                LOG.info((Object)"Hive import complete.");
                this.cleanUp(finalPath);
            }
        }
        finally {
            if (!this.isGenerateOnly() && !scriptFile.delete()) {
                LOG.warn((Object)("Could not remove temporary file: " + scriptFile.toString()));
                scriptFile.deleteOnExit();
            }
        }
    }

    private void cleanUp(Path outputPath) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.configuration);
        try {
            if (outputPath != null && fs.exists(outputPath)) {
                FileStatus[] statuses = fs.listStatus(outputPath);
                if (statuses.length == 0) {
                    LOG.info((Object)"Export directory is empty, removing it.");
                    fs.delete(outputPath, true);
                } else if (statuses.length == 1 && statuses[0].getPath().getName().equals("_SUCCESS")) {
                    LOG.info((Object)"Export directory is contains the _SUCCESS file only, removing the directory.");
                    fs.delete(outputPath, true);
                } else {
                    LOG.info((Object)"Export directory is not empty, keeping it.");
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Issue with cleaning (safe to ignore)", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String filename, List<String> env) throws IOException {
        block13: {
            SubprocessSecurityManager subprocessSM = null;
            if (testMode) {
                LOG.debug((Object)"Using external Hive process in test mode.");
                this.executeExternalHiveScript(filename, env);
                return;
            }
            try {
                Class<?> cliDriverClass = Class.forName(HIVE_MAIN_CLASS);
                LOG.debug((Object)"Using in-process Hive instance.");
                subprocessSM = new SubprocessSecurityManager();
                subprocessSM.install();
                String[] argArray = new String[]{"-f", filename};
                Method mainMethod = cliDriverClass.getMethod("main", argArray.getClass());
                mainMethod.invoke(null, new Object[]{argArray});
            }
            catch (ClassNotFoundException cnfe) {
                LOG.debug((Object)"Using external Hive process.");
                this.executeExternalHiveScript(filename, env);
            }
            catch (NoSuchMethodException nsme) {
                throw new IOException("Could not access CliDriver.main()", nsme);
            }
            catch (IllegalAccessException iae) {
                throw new IOException("Could not access CliDriver.main()", iae);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof ExitSecurityException) {
                    ExitSecurityException ese = (ExitSecurityException)cause;
                    int status = ese.getExitStatus();
                    if (status != 0) {
                        throw new IOException("Hive CliDriver exited with status=" + status);
                    }
                    break block13;
                }
                throw new IOException("Exception thrown in Hive", ite);
            }
            finally {
                if (null != subprocessSM) {
                    subprocessSM.uninstall();
                }
            }
        }
    }

    private void executeExternalHiveScript(String filename, List<String> env) throws IOException {
        String hiveExec = this.getHiveBinPath();
        ArrayList<String> args = new ArrayList<String>();
        args.add(hiveExec);
        args.add("-f");
        args.add(filename);
        LoggingAsyncSink logSink = new LoggingAsyncSink(LOG);
        int ret = Executor.exec(args.toArray(new String[0]), env.toArray(new String[0]), logSink, logSink);
        if (0 != ret) {
            throw new IOException("Hive exited with status " + ret);
        }
    }
}

