/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.altus;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.talend.bigdata.launcher.Job;
import org.talend.bigdata.launcher.altus.AltusJobUtil;
import org.talend.bigdata.launcher.altus.CloudConfiguration;

public abstract class AltusJob
extends Job {
    private static Logger ALTUS_LOG = Logger.getLogger(AltusJob.class);
    protected String talendJobName;
    protected String clusterName;
    protected boolean setCredentials = false;
    protected String accessKey;
    protected String secretKey;
    protected String pathToAltusCLI;
    protected String libJars;
    protected Map<String, String> conf;
    protected String jarToExecute;
    protected String mainClass;
    protected List<String> args;
    protected int returnCode;
    protected String jobLogUrl;
    protected boolean jobDone = false;
    protected String jobId;
    protected CloudConfiguration cloudConfiguration;

    public StringBuilder getJobLog() {
        StringBuilder sb = new StringBuilder();
        return sb;
    }

    protected abstract void execute(List<String> var1) throws IOException, GeneralSecurityException;

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public void setJobLogUrl(String jobLogUrl) {
        this.jobLogUrl = jobLogUrl;
    }

    public void cancelJob() throws Exception {
        if (this.jobDone) {
            ALTUS_LOG.info((Object)("No need to send a job cancel request for " + this.getTalendJobName()));
        } else {
            if (this.jobId == null) {
                ALTUS_LOG.info((Object)("Do not have Altus job need to be cancelled for " + this.getTalendJobName()));
                return;
            }
            ALTUS_LOG.info((Object)("Sending cancel request for job " + this.getTalendJobName()));
            Process process = Runtime.getRuntime().exec(new String[]{this.pathToAltusCLI, "dataeng", "terminate-job", "--job-id", this.jobId});
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String jobLog = AltusJobUtil.readStdBufferedReader(stdInput);
            if (jobLog.length() > 0) {
                ALTUS_LOG.info((Object)jobLog.toString());
            } else {
                ALTUS_LOG.error((Object)AltusJobUtil.readStdBufferedReader(stdError));
            }
            stdInput.close();
            stdError.close();
        }
    }

    public int executeJob() throws Exception {
        this.jobDone = false;
        this.execute(this.cloudConfiguration.uploadJars(this.jarToExecute, this.libJars));
        if (this.jobId == null) {
            ALTUS_LOG.error((Object)"JobId is null");
            this.jobDone = true;
            return 1;
        }
        String finalJobStatus = this.waitJobProcessing();
        this.setReturnCode(AltusJobUtil.convertToReturnCode(finalJobStatus));
        this.jobDone = true;
        return this.getReturnCode();
    }

    protected String waitJobProcessing() throws InterruptedException, IOException, GeneralSecurityException {
        String status = AltusJobUtil.STATUS_JOB_QUEUED;
        while (AltusJobUtil.STATUS_JOB_QUEUED.equals(status) || AltusJobUtil.STATUS_JOB_SUBMITTING.equals(status) || AltusJobUtil.STATUS_JOB_RUNNING.equals(status)) {
            Thread.sleep(5000L);
            status = AltusJobUtil.retrieveJobStatus(this.jobId, this.pathToAltusCLI);
        }
        return status;
    }

    public String getTalendJobName() {
        return this.talendJobName;
    }
}

