/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.altus;

import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.talend.bigdata.launcher.altus.CloudConfiguration;
import org.talend.bigdata.launcher.fs.AzureDataLakeStorage;
import org.talend.bigdata.launcher.utils.Utils;

public class AzureConfiguration
implements CloudConfiguration {
    private final String account;
    private final String appId;
    private final String appKey;
    private final String authTokenEndPoint;
    private final String remoteFolder = "remoteFolder";
    private final String remoteStatusFolder = "remoteStatusFolder";
    private static Logger ALTUS_LOG = Logger.getLogger(AzureConfiguration.class);

    public AzureConfiguration(String account, String appId, String authTokenEndPoint, String appKey) {
        this.account = account;
        this.appId = appId;
        this.authTokenEndPoint = authTokenEndPoint;
        this.appKey = appKey;
    }

    @Override
    public List<String> uploadJars(String jobJar, String libJars) {
        ALTUS_LOG.info((Object)("Starting to upload job and dependencies into " + this.account));
        ALTUS_LOG.info((Object)("jobJar:" + jobJar));
        ALTUS_LOG.info((Object)("libjars:" + libJars));
        ArrayList<String> uploadedJars = new ArrayList<String>();
        AzureDataLakeStorage adls = new AzureDataLakeStorage(this.account, this.appId, this.authTokenEndPoint, this.appKey);
        adls.setOverwrite(false);
        String sentFiles = null;
        try {
            sentFiles = Utils.sendFiles(this.remoteFolder, this.remoteStatusFolder, adls, jobJar, libJars);
            uploadedJars.add(Utils.getJobJarUri(this.remoteFolder, jobJar, adls));
            uploadedJars.addAll(Arrays.asList(sentFiles.split(",")));
        }
        catch (StorageException | IOException | URISyntaxException | InvalidKeyException e) {
            throw new RuntimeException("Failed to upload jars : " + e.getMessage());
        }
        ALTUS_LOG.info((Object)("Finish uploading job dependencies into " + this.account));
        return uploadedJars;
    }

    @Override
    public String getSshKeyArg() {
        return "--public-key";
    }

    @Override
    public String getClusterCreationCommand() {
        return "create-azure-cluster";
    }

    @Override
    public String getSshKeyContent(String sshKey) {
        return "file://" + sshKey;
    }

    @Override
    public String getCdhVersion() {
        return "CDH513";
    }
}

