/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.talend.bigdata.launcher.databricks.DatabricksAutoscale;
import org.talend.bigdata.launcher.databricks.DatabricksAwsAttributes;
import org.talend.bigdata.launcher.databricks.DatabricksStorageInfo;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DatabricksCluster {
    private int numWorkers;
    private DatabricksAutoscale autoscale;
    private String sparkVersion;
    private Map<String, String> sparkConf;
    private DatabricksAwsAttributes awsAttributes;
    private String nodeTypeId;
    private String driverNodeTyeId;
    private List<String> sshPublicKeys;
    private Map<String, String> customTags;
    private DatabricksStorageInfo clusterLogConf;
    private DatabricksStorageInfo initScripts;
    private boolean enableElasticDisk;

    public DatabricksCluster(int numWorkers, DatabricksAutoscale autoscale, String sparkVersion, Map<String, String> sparkConf, DatabricksAwsAttributes awsAttributes, String nodeTypeId, String driverNodeTyeId, List<String> sshPublicKeys, Map<String, String> customTags, DatabricksStorageInfo clusterLogConf, DatabricksStorageInfo initScripts, boolean enableElasticDisk) {
        this.numWorkers = numWorkers;
        this.autoscale = autoscale;
        this.sparkVersion = sparkVersion;
        this.sparkConf = sparkConf;
        this.awsAttributes = awsAttributes;
        this.nodeTypeId = nodeTypeId;
        this.driverNodeTyeId = driverNodeTyeId;
        this.sshPublicKeys = sshPublicKeys;
        this.customTags = customTags;
        this.clusterLogConf = clusterLogConf;
        this.initScripts = initScripts;
        this.enableElasticDisk = enableElasticDisk;
    }

    @JsonGetter(value="num_workers")
    public int getNumWorkers() {
        return this.numWorkers;
    }

    @JsonGetter(value="autoscale")
    public DatabricksAutoscale getAutoscale() {
        return this.autoscale;
    }

    @JsonGetter(value="spark_version")
    public String getSparkVersion() {
        return this.sparkVersion;
    }

    @JsonGetter(value="spark_conf")
    public Map<String, String> getSparkConf() {
        return this.sparkConf;
    }

    @JsonGetter(value="aws_attributes")
    public DatabricksAwsAttributes getAwsAttributes() {
        return this.awsAttributes;
    }

    @JsonGetter(value="node_type_id")
    public String getNodeTypeId() {
        return this.nodeTypeId;
    }

    @JsonGetter(value="driver_node_type_id")
    public String getDriverNodeTyeId() {
        return this.driverNodeTyeId;
    }

    @JsonGetter(value="ssh_public_keys")
    public List<String> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    @JsonGetter(value="custom_tags")
    public Map<String, String> getCustomTags() {
        return this.customTags;
    }

    @JsonGetter(value="cluster_log_conf")
    public DatabricksStorageInfo getClusterLogConf() {
        return this.clusterLogConf;
    }

    @JsonGetter(value="init_scripts")
    public DatabricksStorageInfo getInitScripts() {
        return this.initScripts;
    }

    @JsonGetter(value="enable_elastic_disk")
    public boolean isEnableElasticDisk() {
        return this.enableElasticDisk;
    }

    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.toJson();
    }

    public static class Builder {
        private int numWorkers;
        private DatabricksAutoscale autoscale;
        private String sparkVersion;
        private Map<String, String> sparkConf;
        private DatabricksAwsAttributes awsAttributes;
        private String nodeTypeId;
        private String driverNodeTyeId;
        private List<String> sshPublicKeys;
        private Map<String, String> customTags;
        private DatabricksStorageInfo clusterLogConf;
        private DatabricksStorageInfo initScripts;
        private boolean enableElasticDisk = false;

        public Builder withNumWorkers(int numWorkers) {
            this.numWorkers = numWorkers;
            return this;
        }

        public Builder withAutoscale(DatabricksAutoscale autoscale) {
            this.autoscale = autoscale;
            return this;
        }

        public Builder withSparkVersion(String sparkVersion) {
            this.sparkVersion = sparkVersion;
            return this;
        }

        public Builder withSparkConf(Map<String, String> sparkConf) {
            this.sparkConf = sparkConf;
            return this;
        }

        public Builder withAwsAttributes(DatabricksAwsAttributes awsAttributes) {
            this.awsAttributes = awsAttributes;
            return this;
        }

        public Builder withNodeTypeId(String nodeTypeId) {
            this.nodeTypeId = nodeTypeId;
            return this;
        }

        public Builder withDriverNodeTyeId(String driverNodeTyeId) {
            this.driverNodeTyeId = driverNodeTyeId;
            return this;
        }

        public Builder withSshPublicKeys(List<String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            return this;
        }

        public Builder withCustomTags(Map<String, String> customTags) {
            this.customTags = customTags;
            return this;
        }

        public Builder withClusterLogConf(DatabricksStorageInfo clusterLogConf) {
            this.clusterLogConf = clusterLogConf;
            return this;
        }

        public Builder withInitScripts(DatabricksStorageInfo initScripts) {
            this.initScripts = initScripts;
            return this;
        }

        public Builder withEnableElasticDisk(boolean enableElasticDisk) {
            this.enableElasticDisk = enableElasticDisk;
            return this;
        }

        public DatabricksCluster build() {
            return new DatabricksCluster(this.numWorkers, this.autoscale, this.sparkVersion, this.sparkConf, this.awsAttributes, this.nodeTypeId, this.driverNodeTyeId, this.sshPublicKeys, this.customTags, this.clusterLogConf, this.initScripts, this.enableElasticDisk);
        }
    }
}

