/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.talend.bigdata.launcher.databricks.DatabricksStorageDestination;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DatabricksStorageInfo {
    private DatabricksStorageDestination s3;
    private DatabricksStorageDestination dbfs;

    public DatabricksStorageInfo(DatabricksStorageTypeEnum type, String destination) {
        switch (type) {
            case S3: {
                this.s3 = new DatabricksStorageDestination(destination);
                break;
            }
            default: {
                this.dbfs = new DatabricksStorageDestination(destination);
            }
        }
    }

    @JsonGetter(value="s3")
    public DatabricksStorageDestination getS3() {
        return this.s3;
    }

    @JsonGetter(value="dbfs")
    public DatabricksStorageDestination getDBFS() {
        return this.dbfs;
    }

    public static enum DatabricksStorageTypeEnum {
        DBFS("dbfs"),
        S3("s3");

        private String json;

        private DatabricksStorageTypeEnum(String json) {
            this.json = json;
        }

        public String toJson() {
            return this.json;
        }
    }
}

