/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.google.dataproc;

import com.google.api.services.dataproc.Dataproc;
import com.google.api.services.dataproc.model.HadoopJob;
import com.google.api.services.dataproc.model.Job;
import com.google.api.services.dataproc.model.JobPlacement;
import com.google.api.services.dataproc.model.JobReference;
import com.google.api.services.dataproc.model.LoggingConfig;
import com.google.api.services.dataproc.model.SubmitJobRequest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.talend.bigdata.launcher.google.dataproc.DataprocDriver;
import org.talend.bigdata.launcher.google.dataproc.DataprocJobUtil;
import org.talend.bigdata.launcher.google.dataproc.GoogleDataprocJob;

public class DataprocMRJob
extends GoogleDataprocJob {
    private static Logger MR_LOG = Logger.getLogger(DataprocMRJob.class);
    private LoggingConfig loggingConfig;

    private DataprocMRJob(String talendJobName, String clusterName, String region, String projectId, String jarsBucket, String serviceAccountCredentialsPath, Map<String, String> conf, String mainClass, String jarToExecute, String libJars, List<String> args, String logLevel) {
        this.talendJobName = talendJobName;
        this.clusterName = clusterName;
        this.projectId = projectId;
        this.region = region;
        this.jarsBucket = jarsBucket;
        this.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
        this.conf = conf;
        this.mainClass = mainClass;
        this.jarToExecute = jarToExecute;
        this.libJars = libJars;
        this.args = args;
        if (StringUtils.isNotEmpty((String)logLevel)) {
            this.loggingConfig = new LoggingConfig();
            HashMap<String, String> driverLogLevels = new HashMap<String, String>();
            driverLogLevels.put("root", logLevel);
            this.loggingConfig.setDriverLogLevels(driverLogLevels);
        }
    }

    @Override
    protected Job execute(List<String> jarsFileUris) throws IOException, GeneralSecurityException {
        Dataproc dataproc = DataprocDriver.createDataprocClient(this.talendJobName, this.serviceAccountCredentialsPath);
        List<String> remoteArgs = DataprocJobUtil.prepareArgs(this.args);
        Map<String, String> properties = DataprocJobUtil.prepareProperties(this.conf);
        HadoopJob mrJob = new HadoopJob().setMainClass(this.mainClass).setJarFileUris(jarsFileUris).setProperties(properties).setArgs(remoteArgs).setLoggingConfig(this.loggingConfig);
        Job job = new Job().setReference(new JobReference().setJobId(this.talendJobName)).setPlacement(new JobPlacement().setClusterName(this.clusterName)).setHadoopJob(mrJob);
        try {
            MR_LOG.info((Object)("Submitting job " + this.talendJobName + "to Google Dataproc..."));
            return (Job)dataproc.projects().regions().jobs().submit(this.projectId, this.region, new SubmitJobRequest().setJob(job)).execute();
        }
        catch (IOException e) {
            MR_LOG.error((Object)e.getMessage());
            MR_LOG.info((Object)"Trying to use job.");
            Job retrievedJob = (Job)dataproc.projects().regions().jobs().get(this.projectId, this.region, this.talendJobName).execute();
            MR_LOG.info((Object)"Despite exception, job was verified submitted.");
            return retrievedJob;
        }
    }

    public static class Builder {
        protected String serviceAccountCredentialsPath;
        protected String jarsBucket;
        protected String libjars;
        protected String jarToExecute;
        protected String mainClass;
        protected List<String> args;
        protected Map<String, String> conf;
        protected String talendJobName;
        protected String clusterName;
        protected String region;
        protected String projectId;
        protected String logLevel;

        public Builder withJarToExecute(String jarToExecute) {
            this.jarToExecute = jarToExecute;
            return this;
        }

        public Builder withMainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public Builder withJarsBucket(String jarsBucket) {
            this.jarsBucket = jarsBucket;
            return this;
        }

        public Builder withLibJars(String libJars) {
            this.libjars = libJars;
            return this;
        }

        public Builder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder withTalendJobName(String talendJobName) {
            this.talendJobName = talendJobName;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withConf(Map<String, String> conf) {
            this.conf = conf;
            return this;
        }

        public Builder withArgs(List<String> args) {
            this.args = args;
            return this;
        }

        public Builder withServiceAccountCredentialsPath(String serviceAccountCredentialsPath) {
            this.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
            return this;
        }

        public Builder withLogLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public DataprocMRJob build() {
            return new DataprocMRJob(this.talendJobName, this.clusterName, this.region, this.projectId, this.jarsBucket, this.serviceAccountCredentialsPath, this.conf, this.mainClass, this.jarToExecute, this.libjars, this.args, this.logLevel);
        }
    }
}

