/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.google.dataproc;

import com.google.api.services.dataproc.Dataproc;
import com.google.api.services.dataproc.model.CancelJobRequest;
import com.google.cloud.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.parser.ParseException;
import org.talend.bigdata.launcher.Job;
import org.talend.bigdata.launcher.google.dataproc.DataprocDriver;
import org.talend.bigdata.launcher.google.dataproc.DataprocJobUtil;

public abstract class GoogleDataprocJob
extends Job {
    private static Logger DATAPROC_LOG = Logger.getLogger(GoogleDataprocJob.class);
    protected String talendJobName;
    protected String clusterName;
    protected String projectId;
    protected String region;
    protected String jarsBucket;
    protected String serviceAccountCredentialsPath;
    protected String libJars;
    protected Map<String, String> conf;
    protected String jarToExecute;
    protected String mainClass;
    protected List<String> args;
    protected int returnCode;
    protected String jobLogUrl;
    private Storage storage;
    protected boolean jobDone = false;

    public StringBuilder getJobLog() {
        StringBuilder sb = new StringBuilder();
        Matcher m = DataprocJobUtil.GS_URI_PATTERN.matcher(this.jobLogUrl);
        if (m.find()) {
            Bucket bucket = this.getStorage().get(m.group(1), new Storage.BucketGetOption[0]);
            Page bList = bucket.list(new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)m.group(2))});
            Iterator it = bList.iterateAll();
            while (it.hasNext()) {
                Blob blob = (Blob)it.next();
                sb.append("Scanning file: " + blob.getName() + System.getProperty("line.separator"));
                sb.append(new String(blob.getContent(new Blob.BlobSourceOption[0])));
            }
        }
        return sb;
    }

    protected abstract com.google.api.services.dataproc.model.Job execute(List<String> var1) throws IOException, GeneralSecurityException;

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public void setJobLogUrl(String jobLogUrl) {
        this.jobLogUrl = jobLogUrl;
    }

    public Storage getStorage() {
        if (this.storage == null) {
            try {
                this.storage = DataprocDriver.createStorageService(this.serviceAccountCredentialsPath, this.projectId);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create Google Storage client.", e);
            }
        }
        return this.storage;
    }

    public void cancelJob() throws Exception {
        if (this.jobDone) {
            DATAPROC_LOG.info((Object)("No need to send a job cancel request for " + this.getTalendJobName()));
        } else {
            DATAPROC_LOG.info((Object)("Sending cancel request for job " + this.getTalendJobName()));
            Dataproc dataproc = DataprocDriver.createDataprocClient(this.getTalendJobName(), this.serviceAccountCredentialsPath);
            Dataproc.Projects.Regions.Jobs.Cancel request = dataproc.projects().regions().jobs().cancel(this.projectId, this.region, this.getTalendJobName(), new CancelJobRequest());
            request.execute();
        }
    }

    public int executeJob() throws Exception {
        this.jobDone = false;
        com.google.api.services.dataproc.model.Job job = this.execute(this.uploadJars());
        com.google.api.services.dataproc.model.Job finalJob = this.wait(job);
        this.setReturnCode(DataprocJobUtil.convertToReturnCode(finalJob.getStatus()));
        this.setJobLogUrl(this.retrieveLogUri(finalJob));
        this.jobDone = true;
        return this.getReturnCode();
    }

    private com.google.api.services.dataproc.model.Job wait(com.google.api.services.dataproc.model.Job job) throws InterruptedException, IOException, GeneralSecurityException {
        com.google.api.services.dataproc.model.Job newestJob = job;
        Dataproc dataproc = DataprocDriver.createDataprocClient(this.getTalendJobName(), this.serviceAccountCredentialsPath);
        while (!DataprocJobUtil.isJobDone(newestJob.getStatus())) {
            Thread.sleep(2000L);
            newestJob = (com.google.api.services.dataproc.model.Job)dataproc.projects().regions().jobs().get(this.projectId, this.region, this.getTalendJobName()).execute();
        }
        return newestJob;
    }

    private String retrieveLogUri(com.google.api.services.dataproc.model.Job finalJob) throws ParseException, IOException, GeneralSecurityException {
        return finalJob.getDriverOutputResourceUri();
    }

    public List<String> uploadJars() {
        DATAPROC_LOG.info((Object)("Starting to upload dependencies into " + this.jarsBucket));
        Matcher matcher = DataprocJobUtil.GS_URI_PATTERN.matcher(this.jarsBucket);
        if (matcher.find()) {
            ArrayList<String> jarFileUris = new ArrayList<String>();
            String bucketName = matcher.group(1);
            String gsJarFolderPath = matcher.group(2);
            Bucket bucket = this.getStorage().get(bucketName, new Storage.BucketGetOption[0]);
            if (bucket == null) {
                throw new RuntimeException("Bucket " + bucketName + " cannot be found or cannot be read. Please check the Google Storage URI you provided : " + this.jarsBucket);
            }
            jarFileUris.add(this.uploadJobJar(bucket, gsJarFolderPath));
            jarFileUris.addAll(this.uploadExternalJars(bucket, gsJarFolderPath));
            DATAPROC_LOG.info((Object)("Finish uploading dependencies into " + this.jarsBucket));
            return jarFileUris;
        }
        throw new RuntimeException(this.jarsBucket + " is not a valid Google Storage URI (gs://bucket/folder)");
    }

    private String uploadJar(Bucket bucket, String gsJarFolderPath, File localLibJarFile, boolean override) {
        String gsJarUri;
        String jarFileBlobId = gsJarFolderPath + (gsJarFolderPath.endsWith("/") ? "" : "/") + localLibJarFile.getName();
        Blob jarFileBlob = bucket.get(jarFileBlobId, new Storage.BlobGetOption[0]);
        if (jarFileBlob == null || override) {
            try {
                jarFileBlob = bucket.create(jarFileBlobId, (InputStream)new FileInputStream(localLibJarFile), new Bucket.BlobWriteOption[0]);
                gsJarUri = DataprocJobUtil.getGoogleStorageUri(jarFileBlob);
                DATAPROC_LOG.debug((Object)(localLibJarFile.getName() + " has been uploaded to " + gsJarUri));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to upload " + localLibJarFile.getAbsolutePath() + " to Google Storage.", e);
            }
        } else {
            gsJarUri = DataprocJobUtil.getGoogleStorageUri(jarFileBlob);
            DATAPROC_LOG.debug((Object)(localLibJarFile.getName() + " already exists on " + gsJarUri + ". No need to upload it again."));
        }
        return gsJarUri;
    }

    protected List<String> uploadExternalJars(Bucket bucket, String gsJarFolderPath) {
        ArrayList<String> jarFileUris = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.libJars)) {
            for (String libJarPath : this.libJars.split(",", -1)) {
                jarFileUris.add(this.uploadJar(bucket, gsJarFolderPath, new File(libJarPath), false));
            }
        } else {
            DATAPROC_LOG.info((Object)"No jars or external dependencies need to be uploaded on Google Storage.");
        }
        return jarFileUris;
    }

    private String uploadJobJar(Bucket bucket, String gsJarFolderPath) {
        if (StringUtils.isEmpty((String)this.jarToExecute)) {
            throw new RuntimeException("Job jar has not been provided.");
        }
        return this.uploadJar(bucket, gsJarFolderPath, new File(this.jarToExecute), true);
    }

    public String getTalendJobName() {
        return this.talendJobName;
    }
}

