/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.webhcat;

import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.StringTokenizer;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.utils.JobType;
import org.talend.bigdata.launcher.webhcat.WebHCatJob;

public class QueryJob
extends WebHCatJob {
    private JobType mType;
    private String mFileToExecute;

    public QueryJob(FileSystem fs, JobType type) {
        this.mFileSystem = fs;
        this.mType = type;
    }

    @Override
    public int callWS(String libjars) {
        JAXRSClientFactoryBean factory = new JAXRSClientFactoryBean();
        this.mCredentials.setCredentials(factory);
        factory.setAddress(this.mWebhcatEndpoint);
        WebClient client = factory.createWebClient();
        client.path((Object)("templeton/v1/" + this.mType.getType()));
        client.type("application/x-www-form-urlencoded");
        client.accept(new String[]{"*/*"});
        Form form = new Form();
        form.set("user.name", (Object)this.mUsername);
        form.set("file", (Object)(this.mFileSystem.getFileSystemPrefix() + "/" + this.mRemoteFolder + "/file/" + this.mFileToExecute));
        form.set("statusdir", (Object)("/" + this.mStatusFolder));
        client.post((Object)form, String.class);
        return client.getResponse().getStatus();
    }

    @Override
    public String sendFiles() throws IOException, InvalidKeyException, URISyntaxException, StorageException {
        String remote = this.mRemoteFolder;
        String remotefile = remote + "/file";
        String remotelibjars = remote + "/libjars";
        String status = this.mStatusFolder;
        if (this.mFileSystem.exists(remote)) {
            this.mFileSystem.delete(remote);
        }
        if (this.mFileSystem.exists(status)) {
            this.mFileSystem.delete(status);
        }
        this.mFileSystem.mkdir(remote);
        this.mFileSystem.mkdir(remotefile);
        this.mFileSystem.mkdir(remotelibjars);
        this.mFileSystem.copyFromLocal(this.mFileToExecute, remotefile);
        if (this.mLibjars != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.mLibjars, ",");
            while (tokenizer.hasMoreElements()) {
                String jar = (String)tokenizer.nextElement();
                this.mFileSystem.copyFromLocal(jar, remotelibjars);
            }
        }
        return null;
    }

    public void setFileToExecute(String file) {
        this.mFileToExecute = file;
    }
}

