/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.webhcat;

import com.microsoft.azure.storage.StorageException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.List;
import org.talend.bigdata.launcher.Job;
import org.talend.bigdata.launcher.fs.FileSystem;

public abstract class WebHCatJob
extends Job {
    protected FileSystem mFileSystem;
    protected String mStatusFolder;
    protected String mRemoteFolder;
    protected String mWebhcatEndpoint;
    protected String mLibjars;
    protected String mUsername;
    protected List<String> mArgs;

    public abstract String sendFiles() throws IOException, InvalidKeyException, URISyntaxException, StorageException;

    public abstract int callWS(String var1);

    public Integer execute() throws IOException, InterruptedException, InvalidKeyException, URISyntaxException, StorageException {
        String status = this.mStatusFolder;
        String exitCode = status + "/exit";
        final String stderr = status + "/stderr";
        final FileSystem fs = this.mFileSystem;
        class StreamStrErr
        implements Runnable {
            StreamStrErr() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream is = null;
                BufferedReader d = null;
                try {
                    String s;
                    while (!fs.exists(stderr)) {
                        Thread.sleep(2000L);
                    }
                    is = fs.open(stderr);
                    d = new BufferedReader(new InputStreamReader(is));
                    while ((s = d.readLine()) == null) {
                        if (is != null) {
                            is.close();
                        }
                        if (d != null) {
                            d.close();
                        }
                        is = fs.open(stderr);
                        d = new BufferedReader(new InputStreamReader(is));
                    }
                    do {
                        System.err.println(s);
                    } while ((s = d.readLine()) != null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (d != null) {
                        try {
                            d.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        StreamStrErr stream = new StreamStrErr();
        stream.run();
        while (!fs.exists(exitCode)) {
            Thread.sleep(2000L);
        }
        InputStream is = fs.open(exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String r = br.readLine();
        try {
            return Integer.parseInt(r);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public InputStream getStdOut() throws InvalidKeyException, URISyntaxException, StorageException {
        String stdout = this.mStatusFolder + "/stdout";
        if (!this.mFileSystem.exists(stdout)) {
            return null;
        }
        return this.mFileSystem.open(stdout);
    }

    public void setStatusFolder(String folder) {
        this.mStatusFolder = folder;
    }

    public void setRemoteFolder(String folder) {
        this.mRemoteFolder = folder;
    }

    public void setLibJars(String libjars) {
        this.mLibjars = libjars;
    }

    public void setArgs(List<String> args) {
        this.mArgs = args;
    }

    public void setWebhcatEndpoint(String scheme, String endpoint) {
        this.mWebhcatEndpoint = scheme + "://" + endpoint;
    }

    public String getStatusFolder() {
        return this.mStatusFolder;
    }

    public String getRemoteFolder() {
        return this.mRemoteFolder;
    }

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public FileSystem getFileSystem() {
        return this.mFileSystem;
    }
}

