/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.altus;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.talend.bigdata.launcher.altus.CloudConfiguration;

public class AWSConfiguration
implements CloudConfiguration {
    protected String s3AccessKey;
    protected String s3SecretKey;
    protected String s3Region;
    protected String bucketName;
    protected String jarsBucket;
    private static Logger ALTUS_LOG = Logger.getLogger(AWSConfiguration.class);

    public AWSConfiguration(String s3AccessKey, String s3SecretKey, String s3Region, String bucketName, String jarsBucket) {
        this.s3AccessKey = s3AccessKey;
        this.s3SecretKey = s3SecretKey;
        this.s3Region = s3Region;
        this.bucketName = bucketName;
        this.jarsBucket = jarsBucket + (jarsBucket.endsWith("/") ? "" : "/");
    }

    @Override
    public List<String> uploadJars(String jobJar, String libJars) {
        ALTUS_LOG.info((Object)("Starting to upload job and dependencies into " + this.jarsBucket));
        ALTUS_LOG.info((Object)("jobJar:" + jobJar));
        ALTUS_LOG.info((Object)("libjars:" + libJars));
        ArrayList<String> jarFileUris = new ArrayList<String>();
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.s3AccessKey, this.s3SecretKey);
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        AmazonS3 amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).withRegion(this.s3Region)).build();
        jarFileUris.add(this.uploadJobJar(jobJar, amazonS3, this.bucketName, this.jarsBucket));
        jarFileUris.addAll(this.uploadExternalJars(amazonS3, this.bucketName, this.jarsBucket, libJars));
        ALTUS_LOG.info((Object)("Finish uploading job and dependencies into " + this.jarsBucket));
        return jarFileUris;
    }

    private String uploadJar(AmazonS3 amazonS3, String bucketName, String jarFolderPath, File localLibJarPath, boolean override) {
        String libName = localLibJarPath.getName();
        String remoteFilePath = "s3a://" + bucketName + "/" + jarFolderPath + libName;
        ListObjectsV2Result objectListing = amazonS3.listObjectsV2(bucketName, jarFolderPath + libName);
        if (objectListing == null || objectListing.getObjectSummaries().isEmpty() || override) {
            ALTUS_LOG.debug((Object)("Adding jar " + localLibJarPath.getAbsolutePath() + " into " + remoteFilePath));
            try {
                PutObjectResult result = amazonS3.putObject(new PutObjectRequest(bucketName, jarFolderPath + libName, localLibJarPath));
                ALTUS_LOG.debug((Object)(localLibJarPath.getAbsolutePath() + " has been uploaded to " + remoteFilePath));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to upload " + libName + " to Amazon S3.", e);
            }
        } else {
            ALTUS_LOG.debug((Object)(libName + " already exists on " + remoteFilePath + ". No need to upload it again."));
        }
        return remoteFilePath;
    }

    protected List<String> uploadExternalJars(AmazonS3 amazonS3, String bucketName, String jarFolderPath, String libJars) {
        ArrayList<String> jarFileUris = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)libJars)) {
            for (String libJarPath : libJars.split(",", -1)) {
                jarFileUris.add(this.uploadJar(amazonS3, bucketName, jarFolderPath, new File(libJarPath), false));
            }
        } else {
            ALTUS_LOG.info((Object)"No jars or external dependencies need to be uploaded on Amazon S3.");
        }
        return jarFileUris;
    }

    private String uploadJobJar(String jobJar, AmazonS3 amazonS3, String bucketName, String jarFolderPath) {
        if (StringUtils.isEmpty((String)jobJar)) {
            throw new RuntimeException("Job jar has not been provided.");
        }
        return this.uploadJar(amazonS3, bucketName, jarFolderPath, new File(jobJar), true);
    }

    @Override
    public String getSshKeyArg() {
        return " --ssh-private-key ";
    }

    @Override
    public String getClusterCreationCommand() {
        return "create-aws-cluster";
    }

    @Override
    public String getSshKeyContent(String sshKey) {
        String sshKeyContent = "";
        if (sshKey != null) {
            try {
                String sCurrentLine;
                BufferedReader br = new BufferedReader(new FileReader(sshKey));
                while ((sCurrentLine = br.readLine()) != null) {
                    sshKeyContent = sshKeyContent + sCurrentLine + '\n';
                }
                br.close();
            }
            catch (IOException e) {
                ALTUS_LOG.error((Object)e);
            }
        }
        return sshKeyContent;
    }

    @Override
    public String getCdhVersion() {
        return "CDH511";
    }
}

