/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobInputStream;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import org.talend.bigdata.launcher.fs.FileSystem;

public class AzureFileSystem
extends FileSystem {
    protected CloudBlobContainer mContainer;
    private static CloudStorageAccount connection = null;

    public AzureFileSystem(CloudBlobContainer container) {
        this.mContainer = container;
    }

    public AzureFileSystem(String connectionString, String container) {
        try {
            connection = AzureFileSystem.getConnection(connectionString);
            this.mContainer = connection.createCloudBlobClient().getContainerReference(container);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static CloudStorageAccount getConnection(String connectionString) throws InvalidKeyException, URISyntaxException {
        if (connection == null) {
            connection = CloudStorageAccount.parse((String)connectionString);
        }
        return connection;
    }

    public void deleteFolder(String folder, CloudBlobContainer container) throws StorageException, URISyntaxException {
        for (ListBlobItem blobItem : container.listBlobs(folder)) {
            if (blobItem instanceof CloudBlob) {
                CloudBlob blob = (CloudBlob)blobItem;
                blob.delete();
                continue;
            }
            if (!(blobItem instanceof CloudBlobDirectory)) continue;
            this.deleteFolder(((CloudBlobDirectory)blobItem).getPrefix(), container);
        }
    }

    @Override
    public boolean exists(String file) {
        boolean doesExist = false;
        try {
            CloudBlockBlob blob = this.mContainer.getBlockBlobReference(file);
            doesExist = blob.exists();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return doesExist;
    }

    @Override
    public InputStream open(String file) {
        BlobInputStream is = null;
        try {
            CloudBlockBlob blob = this.mContainer.getBlockBlobReference(file);
            is = blob.openInputStream();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return is;
    }

    @Override
    public void delete(String folder) {
        try {
            this.deleteFolder(folder, this.mContainer);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void mkdir(String folder) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(new String().getBytes());
            this.mContainer.getBlockBlobReference(folder).upload((InputStream)in, 0L);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void copyFromLocal(String localFile, String targetFolder) {
        try {
            File file = new File(localFile);
            CloudBlockBlob remotefile = this.mContainer.getBlockBlobReference(targetFolder + "/" + file.getName());
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
            if (this.overwrite || !remotefile.exists()) {
                remotefile.upload((InputStream)new FileInputStream(file), file.length());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public String getFileSystemPrefix() {
        return "wasb://" + this.mContainer.getName() + "@" + this.mContainer.getStorageUri().getPrimaryUri().getHost() + "/";
    }
}

