/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.google.dataproc;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.dataproc.Dataproc;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataprocDriver {
    private static Logger LOG = Logger.getLogger(DataprocDriver.class);

    public static Dataproc createDataprocClient(String applicationName, String serviceAccountCredentialsPath) throws IOException, GeneralSecurityException {
        GoogleCredential credential;
        GoogleCredential googleCredential = credential = StringUtils.isEmpty((String)serviceAccountCredentialsPath) ? GoogleCredential.getApplicationDefault() : DataprocDriver.getServiceAccountCredentialsForDataproc(serviceAccountCredentialsPath);
        if (credential.createScopedRequired()) {
            credential = credential.createScoped(Collections.singletonList("https://www.googleapis.com/auth/cloud-platform"));
        }
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        LOG.info((Object)("Create dataproc object for: " + applicationName));
        return new Dataproc.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
    }

    public static Storage createStorageService(String serviceAccountCredentialsPath, String projectId) throws IOException {
        StorageOptions.Builder builder = (StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(projectId);
        if (StringUtils.isNotEmpty((String)serviceAccountCredentialsPath)) {
            builder.setCredentials((Credentials)DataprocDriver.getServiceAccountCredentialsForStorage(serviceAccountCredentialsPath));
        }
        return (Storage)builder.build().getService();
    }

    private static GoogleCredentials getServiceAccountCredentialsForStorage(String serviceAccountCredentialsPath) throws IOException {
        File serviceAccountCredentialsFile = new File(serviceAccountCredentialsPath);
        FileInputStream serviceAccountCredentialsStream = new FileInputStream(serviceAccountCredentialsFile);
        return GoogleCredentials.fromStream((InputStream)serviceAccountCredentialsStream);
    }

    private static GoogleCredential getServiceAccountCredentialsForDataproc(String serviceAccountCredentialsPath) throws IOException {
        File serviceAccountCredentialsFile = new File(serviceAccountCredentialsPath);
        FileInputStream serviceAccountCredentialsStream = new FileInputStream(serviceAccountCredentialsFile);
        return GoogleCredential.fromStream((InputStream)serviceAccountCredentialsStream);
    }
}

