/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.google.dataproc;

import com.google.api.services.dataproc.Dataproc;
import com.google.api.services.dataproc.model.HiveJob;
import com.google.api.services.dataproc.model.Job;
import com.google.api.services.dataproc.model.JobPlacement;
import com.google.api.services.dataproc.model.JobReference;
import com.google.api.services.dataproc.model.LoggingConfig;
import com.google.api.services.dataproc.model.QueryList;
import com.google.api.services.dataproc.model.SubmitJobRequest;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;
import org.talend.bigdata.launcher.google.dataproc.DataprocDriver;
import org.talend.bigdata.launcher.google.dataproc.DataprocJobUtil;
import org.talend.bigdata.launcher.google.dataproc.GoogleDataprocJob;

public class DataprocHiveJob
extends GoogleDataprocJob {
    private static Logger LOG = Logger.getLogger(DataprocHiveJob.class);
    private List<String> initialisationQueries;
    private List<String> queries = new ArrayList<String>();
    private LoggingConfig loggingConfig;
    private long subJobCounter = 0L;
    private String uuid = UUID.randomUUID().toString();

    private DataprocHiveJob(String talendJobName, String clusterName, String region, String projectId, String jarsBucket, String serviceAccountCredentialsPath, Map<String, String> conf, List<String> initialisationQueries) {
        this.talendJobName = talendJobName;
        this.clusterName = clusterName;
        this.region = region;
        this.projectId = projectId;
        this.jarsBucket = jarsBucket;
        this.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
        this.conf = conf;
        this.initialisationQueries = initialisationQueries;
    }

    public void addQuery(String query) {
        this.queries.add(query);
    }

    public void clearQueriesCache() {
        this.queries.clear();
    }

    public void addLibJars(String libJars) {
        this.libJars = libJars;
    }

    public void clearLibJars() {
        this.libJars = "";
    }

    @Override
    public List<String> uploadJars() {
        LOG.info((Object)("Starting to upload dependencies into " + this.jarsBucket));
        Matcher matcher = DataprocJobUtil.GS_URI_PATTERN.matcher(this.jarsBucket);
        if (matcher.find()) {
            ArrayList<String> jarFileUris = new ArrayList<String>();
            String bucketName = matcher.group(1);
            String gsJarFolderPath = matcher.group(2);
            Bucket bucket = this.getStorage().get(bucketName, new Storage.BucketGetOption[0]);
            if (bucket == null) {
                throw new RuntimeException("Bucket " + bucketName + " cannot be found or cannot be read. Please check the Google Storage URI you provided : " + this.jarsBucket);
            }
            jarFileUris.addAll(this.uploadExternalJars(bucket, gsJarFolderPath));
            LOG.info((Object)("Finish uploading dependencies into " + this.jarsBucket));
            return jarFileUris;
        }
        throw new RuntimeException(this.jarsBucket + " is not a valid Google Storage URI (gs://bucket/folder)");
    }

    @Override
    public String getTalendJobName() {
        return this.talendJobName + "_" + this.uuid + "_" + this.subJobCounter;
    }

    @Override
    protected Job execute(List<String> jarsFileUris) throws IOException, GeneralSecurityException {
        ++this.subJobCounter;
        Dataproc dataproc = DataprocDriver.createDataprocClient(this.getTalendJobName(), this.serviceAccountCredentialsPath);
        Map<String, String> properties = DataprocJobUtil.prepareProperties(this.conf);
        ArrayList<String> fullQueries = new ArrayList<String>();
        fullQueries.addAll(this.initialisationQueries);
        fullQueries.addAll(this.queries);
        HiveJob hiveJob = new HiveJob().setProperties(properties).setJarFileUris(jarsFileUris).setQueryList(new QueryList().setQueries(fullQueries));
        Job job = new Job().setReference(new JobReference().setJobId(this.getTalendJobName())).setPlacement(new JobPlacement().setClusterName(this.clusterName)).setHiveJob(hiveJob);
        try {
            LOG.info((Object)("Submitting job " + this.getTalendJobName() + "to Google Dataproc..."));
            return (Job)dataproc.projects().regions().jobs().submit(this.projectId, this.region, new SubmitJobRequest().setJob(job)).execute();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
            LOG.info((Object)"Trying to use job.");
            Job retrievedJob = (Job)dataproc.projects().regions().jobs().get(this.projectId, this.region, this.getTalendJobName()).execute();
            LOG.info((Object)"Despite exception, job was verified submitted.");
            return retrievedJob;
        }
    }

    public static class Builder {
        protected String talendJobName;
        protected String clusterName;
        protected String region;
        protected String projectId;
        protected String jarsBucket;
        protected Map<String, String> conf;
        protected String serviceAccountCredentialsPath;
        protected List<String> initialisationQueries = new ArrayList<String>();

        public Builder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder withTalendJobName(String talendJobName) {
            this.talendJobName = talendJobName;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withJarsBucket(String jarsBucket) {
            this.jarsBucket = jarsBucket;
            return this;
        }

        public Builder withConf(Map<String, String> conf) {
            this.conf = conf;
            return this;
        }

        public Builder withServiceAccountCredentialsPath(String serviceAccountCredentialsPath) {
            this.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
            return this;
        }

        public Builder withInitialisationQueries(List<String> initialisationQueries) {
            this.initialisationQueries.addAll(initialisationQueries);
            return this;
        }

        public Builder withInitialisationQuery(String initialisationQuery) {
            this.initialisationQueries.add(initialisationQuery);
            return this;
        }

        public DataprocHiveJob build() {
            return new DataprocHiveJob(this.talendJobName, this.clusterName, this.region, this.projectId, this.jarsBucket, this.serviceAccountCredentialsPath, this.conf, this.initialisationQueries);
        }
    }
}

