/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.google.dataproc;

import com.google.api.services.dataproc.model.JobStatus;
import com.google.cloud.storage.Blob;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.talend.bigdata.launcher.google.dataproc.DataprocState;

public class DataprocJobUtil {
    private static Logger LOG = Logger.getLogger(DataprocJobUtil.class);
    public static final Pattern GS_URI_PATTERN = Pattern.compile("^gs:\\/\\/([^\\/]+)\\/(.+)$");

    public static String getGoogleStorageUri(Blob blob) {
        return Joiner.on((String)"/").join((Object)"gs:/", (Object)blob.getBucket(), new Object[]{blob.getName()});
    }

    public static int convertToReturnCode(JobStatus jobStatus) {
        DataprocState state = DataprocState.valueOf(jobStatus.getState());
        LOG.info((Object)("Final state: " + (Object)((Object)state)));
        if (DataprocState.DONE.equals((Object)state)) {
            return 0;
        }
        LOG.error((Object)jobStatus.getDetails());
        return 1;
    }

    public static boolean isJobDone(JobStatus jobStatus) {
        DataprocState state = DataprocState.valueOf(jobStatus.getState());
        LOG.info((Object)("Current state: " + (Object)((Object)state)));
        return DataprocState.DONE.equals((Object)state) || DataprocState.CANCELLED.equals((Object)state) || DataprocState.ERROR.equals((Object)state) || DataprocState.ATTEMPT_FAILURE.equals((Object)state);
    }

    public static List<String> prepareArgs(List<String> args) {
        ArrayList<String> remoteArgs = new ArrayList<String>();
        if (args != null && args.size() > 0) {
            for (String mArg : args) {
                remoteArgs.add(mArg);
            }
        }
        remoteArgs.add("-calledByGoogleDataproc");
        return remoteArgs;
    }

    public static Map<String, String> prepareProperties(Map<String, String> conf) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (conf != null) {
            for (Map.Entry<String, String> element : conf.entrySet()) {
                properties.put(element.getKey(), element.getValue());
            }
        }
        return properties;
    }
}

