/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.jobserver;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPException;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.talend.bigdata.launcher.Job;
import org.talend.bigdata.launcher.jobserver.SparkBatchJob;
import org.talend.bigdata.launcher.security.HDInsightCredentials;
import org.talend.bigdata.launcher.utils.Utils;

public abstract class JobServerJob
extends Job {
    protected String mJarToExecute;
    protected String mClassToExecute;
    protected String mAppName;
    protected String mEndpoint;
    protected String mJobId;
    protected Map<String, String> mConf;
    protected Map<String, String> mTuningConf;
    protected Long mExitCode;
    protected Exception mException;
    private static final String OK = "OK";
    private static final String ERROR = "ERROR";

    public void setClassToExecute(String clazz) {
        this.mClassToExecute = clazz;
    }

    public void setJarToExecute(String jar) {
        this.mJarToExecute = jar;
    }

    public void setAppName(String appName) {
        this.mAppName = appName;
    }

    public Exception getException() {
        return this.mException;
    }

    public Integer getExitCode() {
        return this.mExitCode.intValue();
    }

    private void sendJar() throws Exception {
        JAXRSClientFactoryBean factory = new JAXRSClientFactoryBean();
        this.mCredentials.setCredentials(factory);
        factory.setAddress(this.mEndpoint);
        WebClient client = factory.createWebClient();
        client.path((Object)("sparkjobserver/jars/" + this.mAppName));
        client.type("application/x-www-form-urlencoded");
        WebClient.getConfig((Object)client).getHttpConduit().getClient().setAllowChunking(false);
        client.accept(new String[]{"*/*"});
        int status = 1;
        client.post((Object)new FileInputStream(new File(this.mJarToExecute)));
        status = client.getResponse().getStatus();
        if (status > 400) {
            throw new HTTPException(status, "Error", new URL(this.mEndpoint + "/sparkjobserver/jars/" + this.mAppName));
        }
    }

    private void execute() throws Exception {
        JAXRSClientFactoryBean factory = new JAXRSClientFactoryBean();
        this.mCredentials.setCredentials(factory);
        factory.setAddress(this.mEndpoint);
        WebClient client = factory.createWebClient();
        client.path((Object)"sparkjobserver/jobs");
        client.type("application/x-www-form-urlencoded");
        client.accept(new String[]{"*/*"});
        client.query("appName", new Object[]{this.mAppName});
        client.query("classPath", new Object[]{this.mClassToExecute});
        String result = (String)client.post((Object)Utils.toConfString(this.mConf, this.mTuningConf), String.class);
        int status = client.getResponse().getStatus();
        this.mJobId = (String)((JSONObject)((JSONObject)JSONValue.parse((String)result)).get((Object)"result")).get((Object)"jobId");
        if (status > 400) {
            throw new HTTPException(status, "Error", new URL(this.mEndpoint + "/jobs"));
        }
    }

    private String getResult() throws Exception {
        String result;
        JAXRSClientFactoryBean factory = new JAXRSClientFactoryBean();
        this.mCredentials.setCredentials(factory);
        factory.setAddress(this.mEndpoint);
        WebClient client = factory.createWebClient();
        client.path((Object)("sparkjobserver/jobs/" + this.mJobId));
        client.type("application/x-www-form-urlencoded");
        client.accept(new String[]{"*/*"});
        boolean notDone = true;
        do {
            Thread.sleep(2000L);
        } while (notDone = "RUNNING".equals(((JSONObject)JSONValue.parse((String)(result = (String)client.get(String.class)))).get((Object)"status")));
        return this.parseResult(result);
    }

    private String parseResult(String result) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException {
        JSONObject resultObject = (JSONObject)JSONValue.parse((String)result);
        switch ((String)resultObject.get((Object)"status")) {
            case "OK": {
                this.mExitCode = (Long)resultObject.get((Object)"result");
                break;
            }
            case "ERROR": {
                this.mException = Utils.buildException((JSONObject)resultObject.get((Object)ERROR));
                break;
            }
        }
        return (String)resultObject.get((Object)"status");
    }

    public String executeJob() throws Exception {
        this.sendJar();
        this.execute();
        return this.getResult();
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        HashMap<String, String> tuningConf = new HashMap<String, String>();
        SparkBatchJob j = new SparkBatchJob.Builder().withAppName("test").withClassToExecute("localproject.sample_0_1.sample").withConf(conf).withTuningConf(tuningConf).withCredentials(new HDInsightCredentials("admin", "")).withEndpoint("https://talendhd.azurehdinsight.net").withJarToExecute("C:/Users/rdubois.TALEND/Desktop/sample_0_1.jar").build();
        super.sendJar();
        super.execute();
        if (ERROR.equals(super.getResult())) {
            throw j.getException();
        }
    }
}

