/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.livy;

import com.microsoft.azure.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.livy.LivyJob;
import org.talend.bigdata.launcher.security.Credentials;
import org.talend.bigdata.launcher.utils.Utils;

public class SparkJob
extends LivyJob {
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    private static final String DEAD = "dead";

    private SparkJob(FileSystem fs, Credentials credentials, String remoteFolder, String livyEndpoint, String libJars, String username, String classToExecute, String jarToExecute, Map<String, String> conf, String appName, String driverMemory, String executorMemory, Integer driverCore, Integer executorCore, List<String> args) {
        this.mClassToExecute = classToExecute;
        this.mCredentials = credentials;
        this.mFileSystem = fs;
        this.mJarToExecute = jarToExecute;
        this.mLibjars = libJars;
        this.mLivyEndpoint = livyEndpoint;
        this.mRemoteFolder = remoteFolder;
        this.mUsername = username;
        this.mConf = conf;
        this.mAppName = appName;
        this.mDriverCore = driverCore;
        this.mDriverMemory = driverMemory;
        this.mExecutorCore = executorCore;
        this.mExecutorMemory = executorMemory;
        this.mArgs = args;
    }

    private int getReturnCode(String state) {
        if (SUCCESS.equals(state)) {
            return 0;
        }
        return 1;
    }

    private boolean isJobDone(String state) {
        return SUCCESS.equals(state) || ERROR.equals(state) || DEAD.equals(state);
    }

    private JSONObject createExecuteBody(String remoteLibJars) {
        JSONObject jobj = new JSONObject();
        if (this.mFileSystem != null && this.mJarToExecute != null) {
            jobj.put((Object)"file", (Object)(this.mFileSystem.getFileSystemPrefix() + "/" + this.mRemoteFolder + "/jar/" + new File(this.mJarToExecute).getName()));
        }
        jobj.put((Object)"className", (Object)this.mClassToExecute);
        JSONArray args = new JSONArray();
        args.add((Object)"-calledByLivy");
        if (this.mArgs != null && this.mArgs.size() > 0) {
            for (Object mArg : this.mArgs) {
                args.add(mArg);
            }
        }
        jobj.put((Object)"args", (Object)args);
        JSONObject conf = new JSONObject();
        if (this.mConf != null) {
            for (Map.Entry entry : this.mConf.entrySet()) {
                conf.put(entry.getKey(), entry.getValue());
            }
        }
        jobj.put((Object)"conf", (Object)conf);
        if (remoteLibJars != null) {
            JSONArray jars = new JSONArray();
            for (String jar : remoteLibJars.split(",")) {
                jars.add((Object)jar);
            }
            jobj.put((Object)"jars", (Object)jars);
        }
        jobj.put((Object)"name", (Object)this.mAppName);
        if (this.mDriverCore != null) {
            jobj.put((Object)"driverCores", (Object)this.mDriverCore);
        }
        if (this.mExecutorCore != null) {
            jobj.put((Object)"executorCores", (Object)this.mExecutorCore);
        }
        if (this.mDriverMemory != null) {
            jobj.put((Object)"driverMemory", (Object)this.mDriverMemory);
        }
        if (this.mExecutorMemory != null) {
            jobj.put((Object)"executorMemory", (Object)this.mExecutorMemory);
        }
        return jobj;
    }

    private WebClient createWebClient() {
        JAXRSClientFactoryBean factory = new JAXRSClientFactoryBean();
        this.mCredentials.setCredentials(factory);
        factory.setAddress(this.mLivyEndpoint);
        return factory.createWebClient();
    }

    private Long execute(String remoteLibJars) throws ParseException {
        WebClient client = this.createWebClient();
        client.path((Object)"livy/batches");
        client.type("application/json");
        client.accept(new String[]{"*/*"});
        JSONObject jobj = this.createExecuteBody(remoteLibJars);
        String result = (String)client.post((Object)jobj.toJSONString(), String.class);
        JSONObject jso = (JSONObject)new JSONParser().parse(result);
        Long jobId = (Long)jso.get((Object)"id");
        return jobId;
    }

    @Override
    public String sendFiles() throws IOException, InvalidKeyException, URISyntaxException, StorageException {
        return Utils.sendFiles(this.mRemoteFolder, null, this.mFileSystem, this.mJarToExecute, this.mLibjars);
    }

    private int wait(Long jobId) throws InterruptedException, ParseException {
        WebClient client = this.createWebClient();
        client.path((Object)("livy/batches/" + jobId + "/state"));
        client.type("application/json");
        client.accept(new String[]{"*/*"});
        String state = "";
        while (!this.isJobDone(state)) {
            Thread.sleep(2000L);
            String result = (String)client.get(String.class);
            JSONObject jso = (JSONObject)new JSONParser().parse(result);
            state = (String)jso.get((Object)"state");
        }
        return this.getReturnCode(state);
    }

    private StringBuilder generateLog(Long jobId) throws ParseException {
        WebClient client = this.createWebClient();
        client.path((Object)("livy/batches/" + jobId + "/log"));
        client.type("application/json");
        client.accept(new String[]{"*/*"});
        String result = (String)client.get(String.class);
        JSONObject jso = (JSONObject)new JSONParser().parse(result);
        JSONArray jobLog = (JSONArray)jso.get((Object)"log");
        return Utils.buildLog(jobLog);
    }

    @Override
    public int executeJob() throws Exception {
        String remoteLibJars = this.sendFiles();
        Long jobId = this.execute(remoteLibJars);
        this.returnCode = this.wait(jobId);
        this.log = this.generateLog(jobId);
        return this.getReturnCode();
    }

    public static class Builder {
        protected FileSystem mFileSystem;
        protected String mRemoteFolder;
        protected String mLivyEndpoint;
        protected String mLibjars;
        protected String mUsername;
        protected String mJarToExecute;
        protected String mClassToExecute;
        protected String mDriverMemory;
        protected String mExecutorMemory;
        protected Integer mDriverCore;
        protected Integer mExecutorCore;
        protected List<String> mArgs;
        protected Map<String, String> mConf;
        protected String mAppName;
        protected Credentials mCredentials;

        public Builder withFileSystem(FileSystem fs) {
            this.mFileSystem = fs;
            return this;
        }

        public Builder withJarToExecute(String jarToExecute) {
            this.mJarToExecute = jarToExecute;
            return this;
        }

        public Builder withClassToExecute(String classToExecute) {
            this.mClassToExecute = classToExecute;
            return this;
        }

        public Builder withLivyEndpoint(String endpoint) {
            this.mLivyEndpoint = endpoint;
            return this;
        }

        public Builder withCredentials(Credentials credentials) {
            this.mCredentials = credentials;
            return this;
        }

        public Builder withRemoteFolder(String remoteFolder) {
            this.mRemoteFolder = remoteFolder;
            return this;
        }

        public Builder withUsername(String username) {
            this.mUsername = username;
            return this;
        }

        public Builder withLibJars(String libJars) {
            this.mLibjars = libJars;
            return this;
        }

        public Builder withAppName(String appName) {
            this.mAppName = appName;
            return this;
        }

        public Builder withDriverMemory(String memory) {
            if (memory != null) {
                this.mDriverMemory = memory;
            }
            return this;
        }

        public Builder withExecutorMemory(String memory) {
            if (memory != null) {
                this.mExecutorMemory = memory;
            }
            return this;
        }

        public Builder withDriverCore(String core) {
            if (core != null) {
                this.mDriverCore = Integer.parseInt(core);
            }
            return this;
        }

        public Builder withExecutorCore(String core) {
            if (core != null) {
                this.mExecutorCore = Integer.parseInt(core);
            }
            return this;
        }

        public Builder withConf(Map<String, String> conf) {
            this.mConf = conf;
            return this;
        }

        public Builder withArgs(List<String> args) {
            this.mArgs = args;
            return this;
        }

        public SparkJob build() {
            return new SparkJob(this.mFileSystem, this.mCredentials, this.mRemoteFolder, this.mLivyEndpoint, this.mLibjars, this.mUsername, this.mClassToExecute, this.mJarToExecute, this.mConf, this.mAppName, this.mDriverMemory, this.mExecutorMemory, this.mDriverCore, this.mExecutorCore, this.mArgs);
        }
    }
}

