/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.webhcat;

import com.microsoft.azure.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.utils.Utils;
import org.talend.bigdata.launcher.webhcat.WebHCatJob;

public class MapReduceJob
extends WebHCatJob {
    protected String mJarToExecute;
    protected String mClassToExecute;

    public MapReduceJob(FileSystem fs) {
        this.mFileSystem = fs;
    }

    @Override
    public int callWS(String libjars) {
        JAXRSClientFactoryBean factory = new JAXRSClientFactoryBean();
        this.mCredentials.setCredentials(factory);
        factory.setAddress(this.mWebhcatEndpoint);
        WebClient client = factory.createWebClient();
        client.path((Object)"templeton/v1/mapreduce/jar");
        client.type("application/x-www-form-urlencoded");
        client.accept(new String[]{"*/*"});
        Form form = new Form();
        form.set("user.name", (Object)this.mUsername);
        File jarToExecute = new File(this.mJarToExecute);
        form.set("jar", (Object)(this.mFileSystem.getFileSystemPrefix() + "/" + this.mRemoteFolder + "/jar/" + jarToExecute.getName()));
        form.set("class", (Object)this.mClassToExecute);
        form.set("statusdir", (Object)("/" + this.mStatusFolder));
        form.set("libjars", (Object)libjars);
        form.set("arg", (Object)"-calledByTempleton");
        if (this.mArgs != null && this.mArgs.size() > 0) {
            for (String mArg : this.mArgs) {
                form.set("arg", (Object)mArg);
            }
        }
        client.post((Object)form, String.class);
        return client.getResponse().getStatus();
    }

    @Override
    public String sendFiles() throws IOException, InvalidKeyException, URISyntaxException, StorageException {
        return Utils.sendFiles(this.mRemoteFolder, this.mStatusFolder, this.mFileSystem, this.mJarToExecute, this.mLibjars);
    }

    public void setClassToExecute(String clazz) {
        this.mClassToExecute = clazz;
    }

    public void setJarToExecute(String jar) {
        this.mJarToExecute = jar;
    }
}

