/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.MessageProcessingException;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.talend.bigdata.launcher.databricks.Utils;
import org.talend.bigdata.launcher.databricks.api.dbfs.Endpoints;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.utils.BigDataLauncherException;

public class DatabricksFileSystem
extends FileSystem {
    public final String endpoint;
    public final String token;
    public final String userAgent;
    public String filePath;
    private WebClient client;
    private Gson gson;
    private Map<String, Long> clusterJars;
    private static final int API_MAX_RETRY = 3;
    private static final int API_MAX_SIZE = 0x100000;
    private static Logger LOG = Logger.getLogger(DatabricksFileSystem.class);

    public DatabricksFileSystem(String endpoint, String token, String userAgent) {
        this(endpoint, token, userAgent, true);
    }

    public DatabricksFileSystem(String endpoint, String token, String userAgent, boolean overwrite) {
        this.endpoint = endpoint;
        this.token = token;
        this.userAgent = userAgent;
        this.overwrite = overwrite;
        this.gson = new GsonBuilder().create();
        this.clusterJars = new HashMap<String, Long>();
    }

    public FileInfo getStatus(String remoteFile) {
        this.resetClientForEndpoint(Endpoints.GET_STATUS);
        this.client.type("application/json");
        this.client.query("path", new Object[]{remoteFile});
        Response response = this.client.get();
        if (response.getStatus() == 200) {
            try {
                return (FileInfo)this.gson.fromJson((String)response.readEntity(String.class), FileInfo.class);
            }
            catch (MessageProcessingException ignored) {
                return null;
            }
        }
        return null;
    }

    public List<FileInfo> list(String folder) throws BigDataLauncherException {
        return this.list(folder, false);
    }

    public List<FileInfo> list(String folder, boolean includeSubDir) throws BigDataLauncherException {
        this.resetClientForEndpoint(Endpoints.LIST);
        this.client.type("application/json");
        this.client.query("path", new Object[]{folder});
        Response responseAPICall = this.client.get();
        int statusResult = responseAPICall.getStatus();
        if (statusResult == 200) {
            List<FileInfo> fileList = ((FileInfoList)this.gson.fromJson((String)((String)responseAPICall.readEntity(String.class)), FileInfoList.class)).files;
            if (includeSubDir) {
                FileInfo fileInfo;
                ListIterator<FileInfo> iter = fileList.listIterator();
                while (iter.hasNext() && (fileInfo = iter.next()) != null) {
                    if (!fileInfo.is_dir.booleanValue()) continue;
                    for (FileInfo subFileInfo : this.list(fileInfo.path, true)) {
                        iter.add(subFileInfo);
                    }
                }
            }
            return fileList != null ? fileList : Collections.emptyList();
        }
        if (statusResult == 404) {
            return Collections.emptyList();
        }
        throw new BigDataLauncherException((String)responseAPICall.readEntity(String.class));
    }

    @Override
    public boolean exists(String file) {
        return this.clusterJars.containsKey(file);
    }

    public boolean notExistsOrIsDifferent(String localFile, String mockRemoteFile) {
        boolean remoteJarExist = this.exists(mockRemoteFile);
        if (!remoteJarExist) {
            LOG.debug((Object)(mockRemoteFile + " does not exist on DBFS"));
            return true;
        }
        String jarSize = new File(localFile).length() != this.clusterJars.get(mockRemoteFile).longValue() ? "different" : "the same";
        LOG.debug((Object)(mockRemoteFile + " exists and his size is " + jarSize));
        return new File(localFile).length() != this.clusterJars.get(mockRemoteFile).longValue();
    }

    private void resetClientForEndpoint(Endpoints apiEndpoint) {
        if (this.client == null) {
            this.client = Utils.createClient(this.endpoint);
        } else {
            this.client.reset();
        }
        Utils.resetClientForEndpoint(this.client, this.token, apiEndpoint.getAPIPath(), this.userAgent);
    }

    private OutputStream readFile(OutputStream stream, String path) throws ParseException, IOException {
        return this.readFileBlock(stream, path, 0, 3);
    }

    private OutputStream readFileBlock(OutputStream stream, String path, int offset, int retry) throws ParseException, IOException {
        this.resetClientForEndpoint(Endpoints.READ);
        this.client.type("application/json");
        this.client.query("path", new Object[]{path});
        this.client.query("offset", new Object[]{offset});
        this.client.query("length", new Object[]{0x100000});
        Response response = this.client.get();
        if (response.getStatus() == 200 && retry > 0) {
            Base64 encoder = new Base64();
            JSONObject data = (JSONObject)new JSONParser().parse((String)response.readEntity(String.class));
            int block_size = Integer.parseInt(String.valueOf(data.get((Object)"bytes_read")));
            stream.write(encoder.decode(String.valueOf(data.get((Object)"data"))));
            stream.flush();
            if (block_size == 0x100000) {
                return this.readFileBlock(stream, path, offset + 0x100000, 3);
            }
            return stream;
        }
        if (retry > 0) {
            String content = (String)response.readEntity(String.class);
            return this.readFileBlock(stream, path, offset, --retry);
        }
        throw new BigDataLauncherException((String)response.readEntity(String.class));
    }

    @Override
    public InputStream open(String file) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.readFile(stream, file);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(stream.toByteArray());
    }

    @Override
    public void delete(String folder) throws BigDataLauncherException {
        this.resetClientForEndpoint(Endpoints.DELETE);
        this.client.type("multipart/form-data");
        LinkedList<Attachment> atts = new LinkedList<Attachment>();
        ContentDisposition cd = new ContentDisposition("form-data; name=\"path\";");
        atts.add(new Attachment("path", (InputStream)new ByteArrayInputStream(folder.getBytes()), cd));
        ContentDisposition cd1 = new ContentDisposition("form-data; name=\"overwrite\";");
        atts.add(new Attachment("overwrite", (InputStream)new ByteArrayInputStream(Boolean.toString(this.overwrite).getBytes()), cd1));
        MultipartBody body = new MultipartBody(atts);
        Response result = this.client.post((Object)body);
        if (result.getStatus() != 200) {
            throw new BigDataLauncherException((String)result.readEntity(String.class));
        }
    }

    @Override
    public void mkdir(String folder) {
        this.resetClientForEndpoint(Endpoints.MKDIRS);
        this.client.type("multipart/form-data");
        LinkedList<Attachment> atts = new LinkedList<Attachment>();
        ContentDisposition cd = new ContentDisposition("form-data; name=\"path\";");
        atts.add(new Attachment("path", (InputStream)new ByteArrayInputStream(folder.getBytes()), cd));
        MultipartBody body = new MultipartBody(atts);
        Response result = this.client.post((Object)body);
        if (result.getStatus() != 200) {
            throw new BigDataLauncherException((String)result.readEntity(String.class));
        }
    }

    private void sendFileBlock(long handle, byte[] block) {
        this.sendFileBlock(handle, block, 3);
    }

    private void sendFileBlock(long handle, byte[] block, int retry) {
        this.resetClientForEndpoint(Endpoints.ADD_BLOCK);
        this.client.type("application/json");
        JSONObject body = new JSONObject();
        body.put((Object)"handle", (Object)handle);
        body.put((Object)"data", (Object)new String(block));
        Response response = this.client.post((Object)body.toJSONString());
        if (response.getStatus() != 200 && retry > 0) {
            this.sendFileBlock(handle, block, --retry);
        } else if (retry == 0) {
            throw new BigDataLauncherException((String)response.readEntity(String.class));
        }
    }

    public void copyToLocal(String remoteFile, String localFile) {
        this.copyToLocal(remoteFile, localFile, true);
    }

    public void copyToLocal(String remoteFile, String localFile, boolean localOverwrite) {
        Path localPath = Paths.get(localFile, new String[0]);
        if (localPath.toFile().exists() && !localOverwrite) {
            throw new BigDataLauncherException("Local file already exists : " + localPath.toAbsolutePath().toString());
        }
        if (!localPath.getParent().toFile().exists() && !localPath.getParent().toFile().mkdirs()) {
            throw new BigDataLauncherException("Could not create local folder : " + localPath.getParent().toAbsolutePath().toString());
        }
        try (FileOutputStream fileOutput = new FileOutputStream(localPath.toFile());){
            this.readFile(fileOutput, remoteFile);
        }
        catch (IOException | ParseException e) {
            throw new BigDataLauncherException(e.getMessage());
        }
    }

    @Override
    public void copyFromLocal(String localFile, String target) {
        this.resetClientForEndpoint(Endpoints.CREATE);
        this.client.type("multipart/form-data");
        LinkedList<Attachment> atts = new LinkedList<Attachment>();
        ContentDisposition cd = new ContentDisposition("form-data; name=\"path\";");
        atts.add(new Attachment("path", (InputStream)new ByteArrayInputStream(target.getBytes()), cd));
        ContentDisposition cd1 = new ContentDisposition("form-data; name=\"overwrite\";");
        atts.add(new Attachment("overwrite", (InputStream)new ByteArrayInputStream(Boolean.toString(this.overwrite).getBytes()), cd1));
        MultipartBody body = new MultipartBody(atts);
        Response result = this.client.post((Object)body);
        if (result.getStatus() != 200) {
            throw new BigDataLauncherException((String)result.readEntity(String.class));
        }
        String handle = ((ReadReponseCreate)this.gson.fromJson((String)result.readEntity(String.class), ReadReponseCreate.class)).toStringHandle();
        File file = new File(localFile);
        int file_length = new Long(file.length()).intValue();
        int buffer_size = Math.min(0x100000, file_length);
        byte[] buffer = new byte[buffer_size];
        Base64 encoder = new Base64();
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            while (bis.read(buffer) > 0) {
                byte[] decodedBytes = encoder.encode(buffer);
                this.sendFileBlock(Long.parseLong(handle), decodedBytes);
                if ((file_length -= buffer_size) <= 0 || file_length >= 0x100000) continue;
                buffer_size = file_length;
                buffer = new byte[buffer_size];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resetClientForEndpoint(Endpoints.CLOSE);
        this.client.type("multipart/form-data");
        atts = new LinkedList();
        cd = new ContentDisposition("form-data; name=\"handle\";");
        atts.add(new Attachment("handle", (InputStream)new ByteArrayInputStream(handle.getBytes()), cd));
        body = new MultipartBody(atts);
        result = this.client.post((Object)body);
        if (result.getStatus() != 200) {
            throw new BigDataLauncherException((String)result.readEntity(String.class));
        }
    }

    @Override
    public String getFileSystemPrefix() {
        return null;
    }

    public void updateDatabricksJarList(String baseFolder) {
        this.clusterJars = this.list(baseFolder).stream().filter(x -> x.is_dir == false).collect(Collectors.toMap(x -> x.path, x -> x.file_size));
    }

    public static class FileInfoList {
        public List<FileInfo> files;
    }

    public static class FileInfo {
        public String path;
        public Boolean is_dir;
        public Long file_size;
    }

    public static class ReadReponseCreate {
        public Long handle;

        public String toString() {
            return "Handle number = " + this.handle + "\n";
        }

        public String toStringHandle() {
            return Long.toString(this.handle);
        }
    }

    public static class ReadResponseOpen {
        public long bytes_read;
        public String data;

        public ReadResponseOpen(long read, String dataFile) {
            Base64 decoder = new Base64();
            byte[] decodedBytes = decoder.decode(dataFile);
            this.bytes_read = read;
            this.data = new String(decodedBytes);
        }

        public String toString() {
            String res = "Bytes read = " + this.bytes_read + "\n";
            res = res + "Data = " + this.data;
            return res;
        }
    }

    public static class ReadReponseExists {
        public String path;
        public boolean isDir;
        public long file_size;

        public ReadReponseExists(String path, boolean isDir, long file_size) {
            this.path = path;
            this.isDir = isDir;
            this.file_size = file_size;
        }

        public String toString() {
            String res = "Path read = " + this.path + "\n";
            res = res + "Is Directory = " + this.isDir + "\n";
            res = res + "file_size =" + this.file_size;
            return res;
        }
    }
}

