/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.utils;

import com.microsoft.azure.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.talend.bigdata.launcher.fs.FileSystem;

public class Utils {
    public static String removeFirstSlash(String string) {
        String str = string;
        if (str != null && str.length() > 1 && str.charAt(0) == '/') {
            str = str.substring(1);
        }
        return str;
    }

    public static Exception buildException(JSONObject object) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        JSONArray stackJSONArray = (JSONArray)object.get((Object)"stack");
        String errorClass = (String)object.get((Object)"errorClass");
        String message = (String)object.get((Object)"message");
        if (stackJSONArray == null || errorClass == null) {
            throw new InvalidParameterException("The JSON object must contain the \"stack\" and \"errorClass\" elements.");
        }
        ArrayList<StackTraceElement> stackList = new ArrayList<StackTraceElement>();
        Pattern stackPattern = Pattern.compile("([\\w\\.$_]+)\\.([\\w$_]+)\\((.*java|.*scala)?:(\\d+)\\)");
        Iterator iter = stackJSONArray.iterator();
        while (iter.hasNext()) {
            Matcher stackMatcher = stackPattern.matcher((CharSequence)iter.next());
            if (!stackMatcher.find()) continue;
            stackList.add(new StackTraceElement(stackMatcher.group(1), stackMatcher.group(2), stackMatcher.group(3), Integer.parseInt(stackMatcher.group(4))));
        }
        Class<?> exceptionClass = Class.forName(errorClass);
        Constructor<?> exceptionConstructor = exceptionClass.getConstructor(String.class);
        Exception e = (Exception)exceptionConstructor.newInstance(message);
        StackTraceElement[] stackArray = new StackTraceElement[stackList.size()];
        e.setStackTrace(stackList.toArray(stackArray));
        return e;
    }

    public static StringBuilder buildLog(JSONArray array) {
        StringBuilder sb = new StringBuilder();
        if (array != null) {
            Iterator iter = array.iterator();
            while (iter.hasNext()) {
                sb.append((String)iter.next() + "\n");
            }
        }
        return sb;
    }

    public static String toConfString(Map<String, String> conf, Map<String, String> tuningConf) {
        StringBuilder sb = new StringBuilder("spark {context-settings {");
        if (conf != null) {
            for (Map.Entry<String, String> e : conf.entrySet()) {
                sb.append(e.getKey() + " = \"" + e.getValue() + "\",");
            }
        }
        sb.append("passthrough {");
        if (tuningConf != null) {
            for (Map.Entry<String, String> e : tuningConf.entrySet()) {
                sb.append(e.getKey() + " = \"" + e.getValue() + "\",");
            }
        }
        sb.append("} } }");
        return sb.toString();
    }

    public static String sendFiles(String remoteFolder, String statusFolder, FileSystem fs, String jarToExecute, String libJars) throws IOException, InvalidKeyException, URISyntaxException, StorageException {
        String remote = remoteFolder;
        String remotejar = remote + "/jar";
        String remotelibjars = remote + "/libjars";
        String status = statusFolder;
        boolean overwrite = fs.getOverwrite();
        if (fs.exists(remote)) {
            fs.delete(remote);
        }
        if (status != null && fs.exists(status)) {
            fs.delete(status);
        }
        fs.mkdir(remote);
        fs.mkdir(remotejar);
        fs.mkdir(remotelibjars);
        fs.setOverwrite(true);
        fs.copyFromLocal(jarToExecute, remotejar);
        fs.setOverwrite(overwrite);
        StringBuilder libJarsSb = new StringBuilder();
        if (libJars == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(libJars, ",");
        boolean firstElement = true;
        while (tokenizer.hasMoreElements()) {
            String jar = (String)tokenizer.nextElement();
            if (jar.contains("routines")) {
                fs.setOverwrite(true);
            }
            fs.copyFromLocal(jar, remotelibjars);
            fs.setOverwrite(overwrite);
            if (!firstElement) {
                libJarsSb.append(",");
            }
            firstElement = false;
            libJarsSb.append(fs.getFileSystemPrefix() + "/" + remoteFolder + "/libjars/" + new File(jar).getName());
        }
        return libJarsSb.toString();
    }

    public static String getJobJarUri(String remoteFolder, String jar, FileSystem fs) {
        return fs.getFileSystemPrefix() + "/" + remoteFolder + "/jar/" + new File(jar).getName();
    }
}

