/*
 * Decompiled with CFR 0.152.
 */
package org.talend.cloudera.navigator.api.entity;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MProperty;
import com.cloudera.nav.sdk.model.annotations.MRelation;
import com.cloudera.nav.sdk.model.entities.DatasetField;
import com.cloudera.nav.sdk.model.entities.EndPointProxy;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.relations.RelationRole;
import java.util.ArrayList;
import java.util.List;
import org.talend.cloudera.navigator.api.entity.TalendEntity;
import org.talend.cloudera.navigator.api.util.GeneratorID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MClass(model="talend")
public class TalendEntityChild
extends DatasetField {
    private String parentEntityId;
    private List<String> targetEntitiesId;
    private String entityId;
    @MProperty
    private String link;
    @MRelation(role=RelationRole.PARENT)
    private TalendEntity parent;
    @MRelation(role=RelationRole.TARGET)
    private List<EndPointProxy> targets;

    public TalendEntityChild(String jobId, String parentName, String name, String type) {
        this.entityId = GeneratorID.generateEntityChildID(jobId, parentName, name);
        this.setName(name);
        this.setNamespace("Talend");
        this.setDataType(type);
        this.targetEntitiesId = new ArrayList<String>();
        this.targets = new ArrayList<EndPointProxy>();
    }

    public String generateId() {
        return this.getEntityId();
    }

    public EntityType getEntityType() {
        return EntityType.FIELD;
    }

    public SourceType getSourceType() {
        return SourceType.SDK;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public TalendEntity getParent() {
        return this.parent;
    }

    public void setParent(TalendEntity parent) {
        this.setParentEntityId(parent.generateId());
        this.parent = parent;
    }

    public void addTarget(String targetId) {
        this.targetEntitiesId.add(targetId);
        EndPointProxy endpointProxy = new EndPointProxy(targetId, SourceType.SDK, EntityType.OPERATION_EXECUTION);
        this.targets.add(endpointProxy);
    }

    public String toString() {
        return this.getParentEntityId() + "__" + this.getName() + "(" + this.entityId + ") --->" + this.targetEntitiesId;
    }

    public String getParentEntityId() {
        return this.parentEntityId;
    }

    public void setParentEntityId(String parentEntityId) {
        this.parentEntityId = parentEntityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public List<String> getTargetEntitiesId() {
        return this.targetEntitiesId;
    }

    public void setTargetEntitiesId(List<String> targetEntitiesId) {
        this.targetEntitiesId = targetEntitiesId;
    }

    public List<EndPointProxy> getTargets() {
        return this.targets;
    }
}

