/*
 * Decompiled with CFR 0.152.
 */
package org.talend.cloudera.navigator.api.entity;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MRelation;
import com.cloudera.nav.sdk.model.entities.EndPointProxy;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.relations.RelationRole;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.talend.cloudera.navigator.api.entity.TalendEntity;
import org.talend.cloudera.navigator.api.util.ClouderaAPIUtil;
import org.talend.cloudera.navigator.api.util.GeneratorID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MClass(model="talend")
public class TalendInputOutputEntity
extends TalendEntity {
    private List<String> previousEntitiesId;
    private List<String> nextEntitiesId;
    @MRelation(role=RelationRole.SOURCE)
    private List<EndPointProxy> sourceProxies = new ArrayList<EndPointProxy>();
    @MRelation(role=RelationRole.TARGET)
    private List<EndPointProxy> targetProxies;

    public TalendInputOutputEntity(String jobId, String componentName) {
        super(jobId, componentName);
        this.previousEntitiesId = new ArrayList<String>();
        this.targetProxies = new ArrayList<EndPointProxy>();
        this.nextEntitiesId = new ArrayList<String>();
    }

    public void addNextEntity(String entityId) {
        this.nextEntitiesId.add(entityId);
        EndPointProxy endpointProxy = new EndPointProxy(entityId, SourceType.SDK, EntityType.OPERATION_EXECUTION);
        this.targetProxies.add(endpointProxy);
    }

    public void addPreviousEntity(String entityId) {
        this.previousEntitiesId.add(entityId);
        EndPointProxy endpointProxy = new EndPointProxy(entityId, SourceType.SDK, EntityType.OPERATION_EXECUTION);
        this.sourceProxies.add(endpointProxy);
    }

    public List<EndPointProxy> getSourceProxies() {
        return this.sourceProxies;
    }

    public void setSourceProxies(List<EndPointProxy> sourceProxies) {
        this.sourceProxies = sourceProxies;
    }

    public List<EndPointProxy> getTargetProxies() {
        return this.targetProxies;
    }

    public void setTargetProxies(List<EndPointProxy> targetProxies) {
        this.targetProxies = targetProxies;
    }

    public List<String> getPreviousEntitiesId() {
        return this.previousEntitiesId;
    }

    public List<String> getNextEntitiesId() {
        return this.nextEntitiesId;
    }

    @Override
    public void connectToEntity(List<String> inputs, List<String> outputs) {
        String id;
        Object id2;
        if (CollectionUtils.isEmpty(inputs) && ClouderaAPIUtil.isFileInputOutputComponent(this.getName())) {
            id2 = GeneratorID.generateDatasetID(this.getJobId(), this.getName());
            this.addPreviousEntity((String)id2);
        }
        for (String input : inputs) {
            id = GeneratorID.generateNodeID(this.getJobId(), input);
            this.addPreviousEntity(id);
        }
        if (CollectionUtils.isEmpty(outputs) && ClouderaAPIUtil.isFileInputOutputComponent(this.getName())) {
            id2 = GeneratorID.generateDatasetID(this.getJobId(), this.getName());
            this.addNextEntity((String)id2);
        }
        for (String output : outputs) {
            id = GeneratorID.generateNodeID(this.getJobId(), output);
            this.addNextEntity(id);
        }
    }

    public String toString() {
        return this.previousEntitiesId + "---> " + this.getName() + " (" + this.getEntityId() + ")" + " --->" + this.nextEntitiesId;
    }
}

