/*
 * Decompiled with CFR 0.152.
 */
package org.talend.cloudera.navigator.api.entity;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MRelation;
import com.cloudera.nav.sdk.model.entities.EndPointProxy;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.relations.RelationRole;
import java.util.ArrayList;
import java.util.List;
import org.talend.cloudera.navigator.api.entity.TalendEntity;
import org.talend.cloudera.navigator.api.util.GeneratorID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MClass(model="talend")
public class TalendOutputEntity
extends TalendEntity {
    private List<String> previousEntitiesId;
    @MRelation(role=RelationRole.SOURCE)
    private List<EndPointProxy> sourceProxies = new ArrayList<EndPointProxy>();

    public TalendOutputEntity(String jobId, String componentName) {
        super(jobId, componentName);
        this.previousEntitiesId = new ArrayList<String>();
    }

    public void addPreviousEntity(String entityId) {
        this.previousEntitiesId.add(entityId);
        EndPointProxy endpointProxy = new EndPointProxy(entityId, SourceType.SDK, EntityType.OPERATION_EXECUTION);
        this.sourceProxies.add(endpointProxy);
    }

    public List<String> getPreviousEntitiesId() {
        return this.previousEntitiesId;
    }

    public List<EndPointProxy> getSourceProxies() {
        return this.sourceProxies;
    }

    public String toString() {
        return this.previousEntitiesId + "---> " + this.getName() + " (" + this.getEntityId() + ")";
    }

    @Override
    public void connectToEntity(List<String> inputs, List<String> outputs) {
        for (String input : inputs) {
            String id = GeneratorID.generateNodeID(this.getJobId(), input);
            this.addPreviousEntity(id);
        }
    }
}

