/*
 * Decompiled with CFR 0.152.
 */
package org.talend.cloudera.navigator.api.util;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.talend.cloudera.navigator.api.NavigatorNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClouderaAPIUtil {
    public static final String[] FILE_INPUT_OUTPUT_COMPONENT_PREFIXS = new String[]{"tFile", "tHDFS", "tParquet", "tAvro"};

    public static boolean isFileInputOutputComponent(String componentName) {
        for (String prefix : FILE_INPUT_OUTPUT_COMPONENT_PREFIXS) {
            if (!componentName.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static String getDatasetName(String path) {
        if (StringUtils.isNotBlank((String)path)) {
            String[] separatedPath = path.split("/");
            for (int i = separatedPath.length - 1; i >= 0; --i) {
                if (!StringUtils.isNotBlank((String)separatedPath[i])) continue;
                return separatedPath[i];
            }
        }
        return "UnamedTalendDataset";
    }

    public static NavigatorNode retrieveNavigatorNode(String name, List<NavigatorNode> navigatorNodes) {
        for (NavigatorNode navigatorNode : navigatorNodes) {
            if (!name.equals(navigatorNode.getName())) continue;
            return navigatorNode;
        }
        return null;
    }

    public static Boolean isThisComponentContainsThisField(String componentName, String fieldName, List<NavigatorNode> navigatorNodes) {
        NavigatorNode outputNavigatorNode = ClouderaAPIUtil.retrieveNavigatorNode(componentName, navigatorNodes);
        return outputNavigatorNode != null && outputNavigatorNode.getSchema().containsKey(fieldName);
    }
}

