/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.functions;

import java.util.Iterator;
import org.talend.bigdata.dataflow.functions.FlatMapper;

public abstract class FlatMapperIterator<IN, OUT>
implements FlatMapper<IN, OUT>,
Iterator<OUT> {
    private static final long serialVersionUID = 1L;
    private boolean mInitialized = false;
    private Iterator<OUT> mOutToProcess;
    private final Iterator<IN> mInputs;

    public FlatMapperIterator(Iterator<IN> inputs) {
        this.mInputs = inputs;
    }

    @Override
    public boolean hasNext() {
        try {
            if (null != this.mOutToProcess && this.mOutToProcess.hasNext()) {
                return true;
            }
            while (this.mInputs.hasNext()) {
                if (!this.mInitialized) {
                    this.prepare();
                    this.mInitialized = true;
                }
                this.mOutToProcess = this.flatMap(this.mInputs.next()).iterator();
                if (!this.mOutToProcess.hasNext()) continue;
                return true;
            }
            if (this.mInitialized) {
                this.cleanup();
                this.mInitialized = false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    @Override
    public OUT next() {
        return this.mOutToProcess.next();
    }

    @Override
    public void remove() {
        this.mOutToProcess.remove();
    }
}

