/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hexpr;

import java.util.Comparator;
import org.apache.avro.Schema;

public abstract class HExpr {
    private final HExpr mParent;
    private final String mName;
    private final Schema mSchema;
    private final boolean mNullable;
    private final HExpr mRoot;
    private final String mFqName;
    private final HExpr mNamedParent;
    private final HExpr mContainerParent;
    private final int mCardinalityLevel;

    protected HExpr(HExpr parent, String name, Schema schema, boolean nullable) {
        String fqName;
        this.mParent = parent;
        this.mName = name;
        this.mSchema = schema;
        this.mNullable = nullable;
        this.mRoot = parent == null ? this : parent.getRoot();
        String string = fqName = this.mParent != null ? this.mParent.getFullyQualifiedName() : null;
        this.mFqName = fqName != null && this.mName != null ? fqName + "." + this.mName : (fqName != null ? fqName : this.mName);
        this.mCardinalityLevel = this.mParent == null ? 0 : (this.isArray() ? this.mParent.getCardinalityLevel() + 1 : this.mParent.getCardinalityLevel());
        this.mNamedParent = this.mParent == null ? null : this.mParent.getNamedParentOrThis();
        this.mContainerParent = this.mParent == null ? null : this.mParent.getContainerParentOrThis();
    }

    public static String getTag(String in) {
        int index = in.indexOf(46);
        return index == -1 ? in : in.substring(0, index);
    }

    public HExpr getParent() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public String getFullyQualifiedName() {
        return this.mFqName;
    }

    public HExpr getRoot() {
        return this.mRoot;
    }

    public HExpr getNamedParent() {
        return this.mNamedParent;
    }

    public HExpr getContainerParent() {
        return this.mContainerParent;
    }

    private HExpr getNamedParentOrThis() {
        return this.mName != null ? this : this.getNamedParent();
    }

    private HExpr getContainerParentOrThis() {
        return this.isArray() || this.mParent == null ? this : this.getContainerParent();
    }

    public int getCardinalityLevel() {
        return this.mCardinalityLevel;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isRecord() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isNullable() {
        return this.mNullable;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " <" + this.mFqName + ">" + (this.mName == null ? "-unnamed" : "");
    }

    public static class FqNameComparable
    implements Comparator<HExpr> {
        @Override
        public int compare(HExpr o1, HExpr o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            int cmp = o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
            if (cmp != 0) {
                return cmp;
            }
            return o1.getName() == null ? 1 : -1;
        }
    }
}

