/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hexpr;

import java.util.List;
import org.apache.avro.Schema;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hexpr.HExprArray;
import org.talend.bigdata.dataflow.hexpr.HExprPrimitive;
import org.talend.bigdata.dataflow.hexpr.HExprRecord;

public class HFactory {
    HExpr create(HExpr parent, String tag, Schema schema, boolean nullable) {
        switch (schema.getType()) {
            case ARRAY: {
                return this.createArray(parent, tag, schema, nullable);
            }
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FIXED: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                return this.createPrimitive(parent, tag, schema, nullable);
            }
            case ENUM: {
                throw new UnsupportedOperationException("ENUM not supported ...");
            }
            case MAP: {
                throw new UnsupportedOperationException("MAP not supported ...");
            }
            case RECORD: {
                return this.createRecord(parent, tag, schema, nullable);
            }
            case UNION: {
                return this.createUnion(parent, tag, schema);
            }
        }
        return null;
    }

    HExprArray createArray(HExpr parent, String tag, Schema schema, boolean nullable) {
        HExprArray hexp = new HExprArray(parent, tag, schema, nullable);
        this.create(hexp, null, schema.getElementType(), false);
        return hexp;
    }

    HExprPrimitive createPrimitive(HExpr parent, String tag, Schema schema, boolean nullable) {
        HExprPrimitive hexp = new HExprPrimitive(parent, tag, schema, nullable);
        return hexp;
    }

    HExprRecord createRecord(HExpr parent, String tag, Schema schema, boolean nullable) {
        HExprRecord hexp = new HExprRecord(parent, tag, schema, nullable);
        for (Schema.Field f : schema.getFields()) {
            this.create(hexp, f.name(), f.schema(), false);
        }
        return hexp;
    }

    HExpr createUnion(HExpr parent, String tag, Schema schema) {
        List possible = schema.getTypes();
        return this.create(parent, tag, ((Schema)possible.get(0)).getType() == Schema.Type.NULL ? (Schema)possible.get(1) : (Schema)possible.get(0), true);
    }
}

