/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hexpr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hexpr.HFactory;

public class HTree
implements Iterable<HExpr> {
    private final String mBaseTag;
    private final Schema mBaseSchema;
    private final HashMap<String, HExpr> mAllExpressions = new HashMap();
    private final ArrayList<HExpr> mDfAllExpressions = new ArrayList();
    private final HashMap<HExpr, ArrayList<HExpr>> mChildren = new HashMap();

    public HTree(String tag, Schema schema) {
        this.mBaseTag = tag;
        this.mBaseSchema = schema;
        new HTreeFactory().create(null, tag, schema, false);
    }

    public String getRootTag() {
        return this.mBaseTag;
    }

    public Schema getRootSchema() {
        return this.mBaseSchema;
    }

    public List<HExpr> getFields(HExpr expr) {
        if (expr.isArray()) {
            return this.getFields(this.getChildren(expr).get(0));
        }
        if (!expr.isRecord()) {
            return Collections.emptyList();
        }
        return this.getChildren(expr);
    }

    public List<HExpr> getFieldsPrimitive(HExpr expr) {
        List<HExpr> fields = this.getFields(expr);
        if (fields.size() == 0) {
            return fields;
        }
        ArrayList<HExpr> results = new ArrayList<HExpr>();
        for (HExpr child : fields) {
            if (!child.isPrimitive()) continue;
            results.add(child);
        }
        return results;
    }

    public Iterable<HExpr> getChildrenRecord(HExpr expr) {
        List<HExpr> fields = this.getFields(expr);
        if (fields.size() == 0) {
            return fields;
        }
        ArrayList<HExpr> results = new ArrayList<HExpr>();
        for (HExpr child : fields) {
            if (!child.isRecord()) continue;
            results.add(child);
        }
        return results;
    }

    public Iterable<HExpr> getChildrenArray(HExpr expr) {
        List<HExpr> fields = this.getFields(expr);
        if (fields.size() == 0) {
            return fields;
        }
        ArrayList<HExpr> results = new ArrayList<HExpr>();
        for (HExpr child : fields) {
            if (!child.isArray()) continue;
            results.add(child);
        }
        return results;
    }

    public HExpr getExpression(String fqName) {
        return this.mAllExpressions.get(fqName);
    }

    public List<HExpr> getChildren(HExpr hexpr) {
        ArrayList<HExpr> children = this.mChildren.get(hexpr);
        return children != null ? children : Collections.emptyList();
    }

    @Override
    public Iterator<HExpr> iterator() {
        return this.mDfAllExpressions.iterator();
    }

    private class HTreeFactory
    extends HFactory {
        private HTreeFactory() {
        }

        @Override
        HExpr create(HExpr parent, String tag, Schema schema, boolean nullable) {
            int pos = HTree.this.mDfAllExpressions.size();
            HTree.this.mDfAllExpressions.add(null);
            HExpr hexpr = super.create(parent, tag, schema, nullable);
            HTree.this.mAllExpressions.put(hexpr.getFullyQualifiedName(), hexpr);
            HTree.this.mDfAllExpressions.set(pos, hexpr);
            if (parent != null) {
                ArrayList<HExpr> children = (ArrayList<HExpr>)HTree.this.mChildren.get(parent);
                if (children == null) {
                    children = new ArrayList<HExpr>();
                    HTree.this.mChildren.put(parent, children);
                }
                children.add(hexpr);
            }
            return hexpr;
        }
    }
}

