/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hmap;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avro.generic.IndexedRecord;
import org.talend.bigdata.dataflow.hexpr.AvroSetter;
import org.talend.bigdata.dataflow.hexpr.HExprRecord;
import org.talend.bigdata.dataflow.hmap.AvroMapTransformer;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.hmap.PostProcessor;

public class AvroJoiner<EMIT_CONTEXT> {
    private final HMapSpec mSpec;
    private final HashMap<HMapSpec.OutputDef, AvroJoinEmitter<EMIT_CONTEXT>> mOut = new HashMap();
    private final ArrayList<JoinStep> mJoinSteps;
    private boolean mUniqueMainProcessed = false;
    private final int[] mInputOrderToJoinStepOrder;
    private static final boolean AVOID_NULL_RECORD_OUTPUT = true;

    public AvroJoiner(HMapSpec spec) {
        this.mSpec = spec;
        if (this.mSpec.isTransform()) {
            this.mInputOrderToJoinStepOrder = null;
            this.mJoinSteps = null;
        } else {
            this.mInputOrderToJoinStepOrder = new int[spec.getInputSize()];
            boolean hasRejectInner = this.mSpec.getOutputs(HMapSpec.OutputType.REJECT_INNER).iterator().hasNext();
            this.mJoinSteps = new ArrayList();
            for (HMapSpec.InputDef in : this.mSpec.getInputs()) {
                HMapSpec.JoinDef jd = in.getJoin();
                block0 : switch (jd.getJoinType()) {
                    case MAIN: {
                        break;
                    }
                    case INNER: {
                        this.mInputOrderToJoinStepOrder[in.getOrder()] = this.mJoinSteps.size();
                        switch (jd.getJoinMatchType()) {
                            case ALL: {
                                this.mJoinSteps.add(hasRejectInner ? new JoinStepInnerAllWithReject(in) : new JoinStepInnerAll(in));
                                break block0;
                            }
                            case UNIQUE: {
                                this.mJoinSteps.add(hasRejectInner ? new JoinStepInnerUniqueWithReject(in) : new JoinStepInnerUnique(in));
                            }
                        }
                        break;
                    }
                    case LEFT_OUTER: {
                        this.mInputOrderToJoinStepOrder[in.getOrder()] = this.mJoinSteps.size();
                        switch (jd.getJoinMatchType()) {
                            case ALL: {
                                this.mJoinSteps.add(new JoinStepLeftOuterAll(in));
                                break block0;
                            }
                            case UNIQUE: {
                                this.mJoinSteps.add(new JoinStepLeftOuterUnique(in));
                            }
                        }
                        break;
                    }
                    case NESTED: {
                        this.mInputOrderToJoinStepOrder[in.getOrder()] = this.mJoinSteps.size();
                        this.mJoinSteps.add(new JoinStepNested(in));
                    }
                }
            }
        }
    }

    public void reset() {
        this.mUniqueMainProcessed = false;
        for (HMapSpec.OutputDef out : this.mSpec.getOutputs()) {
            out.getSetter().reset();
        }
        if (this.mJoinSteps != null) {
            for (JoinStep js : this.mJoinSteps) {
                js.resetRecords();
            }
        }
    }

    public void addEmitter(HMapSpec.OutputDef out, AvroJoinEmitter<EMIT_CONTEXT> emitter) {
        this.mOut.put(out, emitter);
    }

    public void transformNoJoin(EMIT_CONTEXT context, HMapSpec.InputDef in, IndexedRecord record) {
        if (!this.doFiltersPostProcessAndEmit(context, in, record, HMapSpec.OutputType.NORMAL)) {
            this.doFiltersPostProcessAndEmit(context, in, record, HMapSpec.OutputType.REJECT_FILTERS);
        }
    }

    public void addLookup(HMapSpec.InputDef in, IndexedRecord record) {
        this.mJoinSteps.get(this.mInputOrderToJoinStepOrder[in.getOrder()]).addRecord(record);
    }

    public void transformMain(EMIT_CONTEXT context, HMapSpec.InputDef in, IndexedRecord record) {
        if (this.mUniqueMainProcessed) {
            return;
        }
        try {
            this.transformJoinStep(0, context, in, record);
        }
        catch (AbortOnFirstRejectInnerException abortOnFirstRejectInnerException) {
            // empty catch block
        }
        if (in.getJoin().getJoinMatchType() == HMapSpec.JoinMatchType.UNIQUE) {
            this.mUniqueMainProcessed = true;
        }
    }

    public void finishJoinKey(EMIT_CONTEXT context) {
        try {
            this.transformJoinStep(0, context, null, null);
        }
        catch (AbortOnFirstRejectInnerException abortOnFirstRejectInnerException) {
            // empty catch block
        }
    }

    private void transformJoinStep(int depth, EMIT_CONTEXT context, HMapSpec.InputDef mainIn, IndexedRecord mainRecord) throws AbortOnFirstRejectInnerException {
        if (this.mJoinSteps != null && depth < this.mJoinSteps.size()) {
            JoinStep js = this.mJoinSteps.get(depth);
            boolean resetToStart = true;
            while (js.incrementPosition(resetToStart)) {
                resetToStart = false;
                try {
                    this.transformJoinStep(depth + 1, context, mainIn, mainRecord);
                }
                catch (AbortOnFirstRejectInnerException e) {
                    AbortOnFirstRejectInnerException.absorbAbort(js, e);
                    break;
                }
            }
        } else {
            boolean rejectedInner = false;
            for (JoinStep js : this.mJoinSteps) {
                if (rejectedInner |= !js.transformCurrent(HMapSpec.OutputType.NORMAL)) break;
            }
            if (rejectedInner) {
                rejectedInner = false;
                for (JoinStep js : this.mJoinSteps) {
                    if (rejectedInner |= !js.transformCurrent(HMapSpec.OutputType.REJECT_INNER)) break;
                }
                this.doFiltersPostProcessAndEmit(context, mainIn, mainRecord, HMapSpec.OutputType.REJECT_INNER);
                throw new AbortOnFirstRejectInnerException();
            }
            if (!this.doFiltersPostProcessAndEmit(context, mainIn, mainRecord, HMapSpec.OutputType.NORMAL)) {
                for (JoinStep js : this.mJoinSteps) {
                    js.transformCurrent(HMapSpec.OutputType.REJECT_FILTERS);
                }
                this.doFiltersPostProcessAndEmit(context, mainIn, mainRecord, HMapSpec.OutputType.REJECT_FILTERS);
            }
        }
    }

    private boolean doFiltersPostProcessAndEmit(EMIT_CONTEXT context, HMapSpec.InputDef mainIn, IndexedRecord mainRecord, HMapSpec.OutputType outType) {
        if (mainIn != null && mainRecord != null) {
            for (AvroMapTransformer amt : mainIn.getTransformers(outType)) {
                amt.transformInput(mainRecord);
            }
        }
        boolean isEmitted = false;
        for (HMapSpec.OutputDef out : this.mSpec.getOutputs(outType)) {
            AvroSetter as = out.getSetter();
            IndexedRecord r = as.getRootValue();
            if (r == null) {
                r = ((HExprRecord)as.getRootHExpr()).createEmptyRecord();
            }
            if (out.isKeptAfterFilters(r)) {
                HMapSpec.OutputDef actualOut;
                AvroJoinEmitter<EMIT_CONTEXT> emitter;
                PostProcessor<? extends IndexedRecord> pp = out.getPostProcessor();
                if (pp != null) {
                    pp.postProcess((IndexedRecord)r);
                }
                if ((emitter = this.mOut.get(actualOut = out.getRedirect())) != null) {
                    if (actualOut.isFlattened()) {
                        for (IndexedRecord flattened : (Iterable)r.get(0)) {
                            emitter.emit(context, actualOut.getTag(), flattened);
                        }
                    } else {
                        emitter.emit(context, actualOut.getTag(), r);
                    }
                }
                isEmitted = true;
            }
            as.reset();
        }
        return isEmitted;
    }

    private static final class AbortOnFirstRejectInnerException
    extends Exception {
        private static final boolean ENABLED = true;
        private static final long serialVersionUID = 1L;

        private AbortOnFirstRejectInnerException() {
        }

        public static void absorbAbort(JoinStep js, AbortOnFirstRejectInnerException e) throws AbortOnFirstRejectInnerException {
            if (js instanceof JoinStepInnerAllWithReject || js instanceof JoinStepInnerUniqueWithReject) {
                return;
            }
            throw e;
        }
    }

    private class JoinStepNested
    extends JoinStepLeftOuterAll {
        JoinStepNested(HMapSpec.InputDef in) {
            super(in);
        }

        @Override
        boolean incrementPosition(boolean reset) {
            super.incrementPosition(reset);
            return this.mIndex == 0;
        }

        @Override
        boolean transformCurrent(HMapSpec.OutputType outType) {
            if (this.mRecords.size() == 0) {
                this.mIn.getGetter().reset();
            } else {
                Iterable transformers = outType == HMapSpec.OutputType.NORMAL ? this.mOutputTransformers : (outType == HMapSpec.OutputType.REJECT_FILTERS ? this.mOutputRejectTransformers : this.mOutputRejectInnerTransformers);
                for (AvroMapTransformer amt : transformers) {
                    for (IndexedRecord record : this.mRecords) {
                        amt.transformInput(record);
                    }
                }
            }
            return true;
        }
    }

    private class JoinStepInnerAllWithReject
    extends JoinStepLeftOuterAll {
        JoinStepInnerAllWithReject(HMapSpec.InputDef in) {
            super(in);
        }

        @Override
        boolean transformCurrent(HMapSpec.OutputType outType) {
            super.transformCurrent(outType);
            return this.mRecords.size() != 0;
        }
    }

    private class JoinStepInnerUniqueWithReject
    extends JoinStepLeftOuterUnique {
        JoinStepInnerUniqueWithReject(HMapSpec.InputDef in) {
            super(in);
        }

        @Override
        boolean transformCurrent(HMapSpec.OutputType outType) {
            super.transformCurrent(outType);
            return this.mRecord != null;
        }
    }

    private class JoinStepLeftOuterAll
    extends JoinStepInnerAll {
        JoinStepLeftOuterAll(HMapSpec.InputDef in) {
            super(in);
        }

        @Override
        boolean incrementPosition(boolean reset) {
            super.incrementPosition(reset);
            return this.mRecords.size() == 0 ? this.mIndex == 0 : this.mIndex < this.mRecords.size();
        }

        @Override
        boolean transformCurrent(HMapSpec.OutputType outType) {
            if (this.mRecords.size() == 1 && this.mRecords.get(0) == null) {
                this.mIn.getGetter().reset();
            } else if (this.mRecords.size() != 0) {
                super.transformCurrent(outType);
            } else {
                this.mIn.getGetter().reset();
            }
            return true;
        }
    }

    private class JoinStepInnerAll
    extends JoinStep {
        protected int mIndex;
        protected final ArrayList<IndexedRecord> mRecords;

        JoinStepInnerAll(HMapSpec.InputDef in) {
            super(in);
            this.mIndex = 0;
            this.mRecords = new ArrayList();
        }

        @Override
        void resetRecords() {
            this.mRecords.clear();
        }

        @Override
        void addRecord(IndexedRecord record) {
            this.mRecords.add(record);
        }

        @Override
        boolean incrementPosition(boolean reset) {
            this.mIndex = reset ? 0 : ++this.mIndex;
            return this.mIndex < this.mRecords.size();
        }

        @Override
        boolean transformCurrent(HMapSpec.OutputType outType) {
            Iterable transformers = outType == HMapSpec.OutputType.NORMAL ? this.mOutputTransformers : (outType == HMapSpec.OutputType.REJECT_FILTERS ? this.mOutputRejectTransformers : this.mOutputRejectInnerTransformers);
            for (AvroMapTransformer amt : transformers) {
                amt.transformInput(this.mRecords.get(this.mIndex));
            }
            return true;
        }
    }

    private class JoinStepLeftOuterUnique
    extends JoinStepInnerUnique {
        JoinStepLeftOuterUnique(HMapSpec.InputDef in) {
            super(in);
        }

        @Override
        boolean incrementPosition(boolean reset) {
            return reset;
        }

        @Override
        boolean transformCurrent(HMapSpec.OutputType outType) {
            if (this.mRecord != null) {
                super.transformCurrent(outType);
                return true;
            }
            this.mIn.getGetter().reset();
            return true;
        }
    }

    private class JoinStepInnerUnique
    extends JoinStep {
        protected IndexedRecord mRecord;

        JoinStepInnerUnique(HMapSpec.InputDef in) {
            super(in);
        }

        @Override
        void resetRecords() {
            this.mRecord = null;
        }

        @Override
        void addRecord(IndexedRecord record) {
            if (this.mRecord == null) {
                this.mRecord = record;
            }
        }

        @Override
        boolean incrementPosition(boolean reset) {
            if (reset) {
                return this.mRecord != null;
            }
            return false;
        }

        @Override
        boolean transformCurrent(HMapSpec.OutputType outType) {
            Iterable transformers = outType == HMapSpec.OutputType.NORMAL ? this.mOutputTransformers : (outType == HMapSpec.OutputType.REJECT_FILTERS ? this.mOutputRejectTransformers : this.mOutputRejectInnerTransformers);
            for (AvroMapTransformer amt : transformers) {
                amt.transformInput(this.mRecord);
            }
            return true;
        }
    }

    private abstract class JoinStep {
        protected final Iterable<AvroMapTransformer> mOutputTransformers;
        protected final Iterable<AvroMapTransformer> mOutputRejectTransformers;
        protected final Iterable<AvroMapTransformer> mOutputRejectInnerTransformers;
        protected final HMapSpec.InputDef mIn;

        JoinStep(HMapSpec.InputDef in) {
            this.mIn = in;
            this.mOutputTransformers = in.getTransformers(HMapSpec.OutputType.NORMAL);
            this.mOutputRejectTransformers = in.getTransformers(HMapSpec.OutputType.REJECT_FILTERS);
            this.mOutputRejectInnerTransformers = in.getTransformers(HMapSpec.OutputType.REJECT_INNER);
        }

        abstract void resetRecords();

        abstract void addRecord(IndexedRecord var1);

        abstract boolean incrementPosition(boolean var1);

        abstract boolean transformCurrent(HMapSpec.OutputType var1);
    }

    public static interface AvroJoinEmitter<EMIT_CONTEXT> {
        public void emit(EMIT_CONTEXT var1, String var2, IndexedRecord var3);
    }
}

