/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hmap;

import java.util.ArrayList;
import org.talend.bigdata.dataflow.DataFlow;
import org.talend.bigdata.dataflow.DataFlowPipelineBuilder;
import org.talend.bigdata.dataflow.hmap.HMapSpec;

public class HMapDataFlowBuilder
extends DataFlowPipelineBuilder {
    private final HMapSpec mSpec;

    public HMapDataFlowBuilder(HMapSpec spec) {
        this.mSpec = spec;
        ArrayList<PipelineHMapLoad> loadPipelines = new ArrayList<PipelineHMapLoad>();
        for (HMapSpec.InputDef in : this.mSpec.getInputs()) {
            if (in.isPull()) continue;
            DataFlowPipelineBuilder.Pipeline loadPipeline = new PipelineHMapLoad(in.getTag(), in.getOrder());
            int size = in.getFilterSize();
            for (int i = 0; i < size; ++i) {
                PipelineHMapInputFilter filterPipeline = new PipelineHMapInputFilter(in.getTag(), in.getOrder(), i);
                this.addFrom(loadPipeline, filterPipeline);
                loadPipeline = filterPipeline;
            }
            loadPipelines.add((PipelineHMapLoad)loadPipeline);
        }
        DataFlowPipelineBuilder.Pipeline corePipeline = null;
        if (loadPipelines.size() == 1) {
            corePipeline = new PipelineHMapTransform("transform");
        } else if (loadPipelines.size() > 1) {
            corePipeline = new PipelineHMapJoin("join");
        }
        this.addTo(corePipeline, loadPipelines.toArray(new DataFlowPipelineBuilder.Pipeline[loadPipelines.size()]));
        for (HMapSpec.OutputDef out : this.mSpec.getOutputs()) {
            this.addFrom(corePipeline, new PipelineHMapStore(out.getTag(), out.getOrder()));
        }
    }

    @Override
    public void build(DataFlow<?> df) {
        DataFlowPipelineBuilder.PipelineFactory hMapBackendPipelineBuilder = null;
        String className = null;
        if (df.getClass().getSimpleName().startsWith("Cascading")) {
            className = "org.talend.bigdata.dataflow.cascading.hmap.CascadingHMapPipelineBuilder";
        } else if (df.getClass().getSimpleName().startsWith("SparkBatch")) {
            className = "org.talend.bigdata.dataflow.spark.batch.hmap.SparkHMapPipelineBuilder";
        } else if (df.getClass().getSimpleName().startsWith("SparkStreaming")) {
            className = "org.talend.bigdata.dataflow.spark.streaming.hmap.SparkHMapPipelineBuilder";
        } else if (df.getClass().getSimpleName().startsWith("SparkDataset")) {
            className = "org.talend.bigdata.dataflow.spark.dataset.hmap.SparkDatasetHMapPipelineBuilder";
        } else {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support data flows of type " + df.getClass().getSimpleName());
        }
        try {
            Class<?> c = Class.forName(className);
            hMapBackendPipelineBuilder = (DataFlowPipelineBuilder.PipelineFactory)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot instantiate " + className, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot instantiate " + className, e);
        }
        hMapBackendPipelineBuilder.buildPipelines(df, this.mSpec, this);
    }

    public class PipelineHMapStore
    extends DataFlowPipelineBuilder.Pipeline {
        private final int mOrder;

        private PipelineHMapStore(String tag, int order) {
            super(tag);
            this.mOrder = order;
        }

        public int getOrder() {
            return this.mOrder;
        }
    }

    public class PipelineHMapJoin
    extends DataFlowPipelineBuilder.Pipeline {
        private PipelineHMapJoin(String tag) {
            super(tag);
        }
    }

    public class PipelineHMapTransform
    extends DataFlowPipelineBuilder.Pipeline {
        private PipelineHMapTransform(String tag) {
            super(tag);
        }
    }

    public class PipelineHMapInputFilter
    extends DataFlowPipelineBuilder.Pipeline {
        private final int mOrder;
        public final int mFilterNumber;

        private PipelineHMapInputFilter(String tag, int order, int filterNumber) {
            super(tag);
            this.mFilterNumber = filterNumber;
            this.mOrder = order;
        }

        public int getOrder() {
            return this.mOrder;
        }
    }

    public class PipelineHMapLoad
    extends DataFlowPipelineBuilder.Pipeline {
        private final int mOrder;

        private PipelineHMapLoad(String tag, int order) {
            super(tag);
            this.mOrder = order;
        }

        public int getOrder() {
            return this.mOrder;
        }
    }
}

