/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hmap.pp.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.bigdata.dataflow.hexpr.AvroGetter;
import org.talend.bigdata.dataflow.hexpr.AvroSetter;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hmap.PostProcessor;
import org.talend.bigdata.dataflow.hmap.filter.Condition;
import org.talend.bigdata.dataflow.hmap.filter.WithAvroGetter;
import org.talend.bigdata.dataflow.hmap.filter.WithChildConditions;
import org.talend.bigdata.dataflow.hmap.filter.impl.HExprLoopAny;

public class RemoveNestedRecordIf<RECORD extends IndexedRecord>
implements PostProcessor<RECORD>,
WithChildConditions<RECORD>,
WithAvroGetter {
    private static final long serialVersionUID = 1L;
    private final String mExprLoop;
    private final Condition<RECORD> mCondition;
    private transient AvroGetter mGetter;
    private transient HExpr mHExprLoop;
    private transient AvroSetterWithPublic mSetter;

    public RemoveNestedRecordIf(String exprLoop, Condition<RECORD> condition) {
        this.mExprLoop = exprLoop;
        this.mCondition = condition;
    }

    @Override
    public void postProcess(RECORD record) {
        if (this.mGetter == null) {
            HExprLoopAny.setAvroGetterOnAllChildConditions(this, new AvroGetter("X", record.getSchema()));
        }
        if (this.mHExprLoop == null) {
            this.mHExprLoop = this.mGetter.getHExpr(this.mGetter.getRootHExpr().getName() + '.' + this.mExprLoop);
        }
        if (this.mSetter == null) {
            this.mSetter = new AvroSetterWithPublic("GET", record.getSchema());
        }
        this.mGetter.setRootValue((IndexedRecord)record);
        boolean modified = false;
        ArrayList<Object> matching = new ArrayList<Object>();
        while (this.mGetter.hasNext(this.mHExprLoop)) {
            Object looped = this.mGetter.next(this.mHExprLoop);
            if (this.mCondition.evaluate(record)) {
                modified = true;
                continue;
            }
            matching.add(looped);
        }
        if (modified) {
            this.mSetter.setRootValueInternal((IndexedRecord)record);
            this.mSetter.setInternal(this.mHExprLoop, matching);
        }
    }

    @Override
    public Iterator<Condition<RECORD>> getChildConditions() {
        return Arrays.asList(this.mCondition).iterator();
    }

    @Override
    public AvroGetter getAvroGetter() {
        return this.mGetter;
    }

    @Override
    public void setAvroGetter(AvroGetter getter) {
        this.mGetter = getter;
    }

    public static class AvroSetterWithPublic
    extends AvroSetter {
        public AvroSetterWithPublic(String tag, Schema schema) {
            super(tag, schema);
        }

        @Override
        public void setInternal(HExpr expr, Object value) {
            super.setInternal(expr, value);
        }

        @Override
        public void setRootValueInternal(IndexedRecord record) {
            super.setRootValueInternal(record);
        }
    }
}

