/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.batch.hmap;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.talend.bigdata.dataflow.DataFlowPipelineBuilder;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.keys.IdentityIndexedRecordGetter;
import org.talend.bigdata.dataflow.keys.IndexedRecordGetter;
import org.talend.bigdata.dataflow.keys.ReusableJoinKeyIndexedRecordFetcher;
import org.talend.bigdata.dataflow.keys.ZeroJoinKeyIndexedRecordFetcher;
import org.talend.bigdata.dataflow.spark.SparkDataFlow;
import org.talend.bigdata.dataflow.spark.common.hmap.JoinOutputFunction;
import org.talend.bigdata.dataflow.spark.common.hmap.MapPairToPairWithCompositeKeyFunction;
import org.talend.bigdata.dataflow.spark.common.hmap.MapPairToPairWithNullKeyFunction;
import org.talend.bigdata.dataflow.spark.common.hmap.MapPairToPairWithSingleKeyFunction;
import org.talend.bigdata.dataflow.spark.common.hmap.Multiplexor;

public class SparkHMapJoin<SDF extends SparkDataFlow<?>>
implements DataFlowPipelineBuilder.PipelinePartialBuilder<SDF, HMapSpec> {
    public static <JOIN_KEY, INPUT_MAIN, INPUT_LOOKUP, OUTPUT> JavaPairRDD<JOIN_KEY, OUTPUT> buildBatchJoin(HMapSpec spec, int joinKeySize, boolean isMultiMain, JavaPairRDD<JOIN_KEY, INPUT_MAIN> main, boolean isMultiLookup, JavaPairRDD<JOIN_KEY, INPUT_LOOKUP> lookup, StorageLevel storage) {
        JoinOutputFunction.JoinInputAdder lookupInputAdder;
        JavaPairRDD groupByData = main.cogroup(lookup);
        JoinOutputFunction.JoinInputAdder mainInputAdder = isMultiMain ? new JoinOutputFunction.InMainNAdder() : new JoinOutputFunction.InMain1Adder();
        JoinOutputFunction.JoinInputAdder joinInputAdder = lookupInputAdder = isMultiLookup ? new JoinOutputFunction.InLookupNAdder() : new JoinOutputFunction.InLookup1Adder();
        IndexedRecordGetter pullRecordGetter = joinKeySize == 0 ? new ZeroJoinKeyIndexedRecordFetcher() : (joinKeySize == 1 ? new ReusableJoinKeyIndexedRecordFetcher() : new IdentityIndexedRecordGetter());
        JoinOutputFunction.OutEmitter output = spec.isMultiOutput() ? new JoinOutputFunction.OutNEmitter() : new JoinOutputFunction.Out1Emitter();
        JoinOutputFunction join = new JoinOutputFunction(spec, mainInputAdder, lookupInputAdder, pullRecordGetter, output);
        JavaPairRDD joinedData = groupByData.mapPartitionsToPair(join);
        if (storage != null && spec.isMultiOutput()) {
            joinedData = joinedData.persist(storage);
        }
        return joinedData;
    }

    public static <JOIN_KEY, INPUT_MAIN, INPUT_LOOKUP, OUTPUT> JavaPairDStream<JOIN_KEY, OUTPUT> buildStreamingJoin(HMapSpec spec, int joinKeySize, boolean isMultiMain, JavaPairDStream<JOIN_KEY, INPUT_MAIN> main, boolean isMultiLookup, JavaPairDStream<JOIN_KEY, INPUT_LOOKUP> lookup, StorageLevel storage) {
        JoinOutputFunction.JoinInputAdder lookupInputAdder;
        JavaPairDStream groupByData = main.cogroup(lookup);
        JoinOutputFunction.JoinInputAdder mainInputAdder = isMultiMain ? new JoinOutputFunction.InMainNAdder() : new JoinOutputFunction.InMain1Adder();
        JoinOutputFunction.JoinInputAdder joinInputAdder = lookupInputAdder = isMultiLookup ? new JoinOutputFunction.InLookupNAdder() : new JoinOutputFunction.InLookup1Adder();
        IndexedRecordGetter pullRecordGetter = joinKeySize == 0 ? new ZeroJoinKeyIndexedRecordFetcher() : (joinKeySize == 1 ? new ReusableJoinKeyIndexedRecordFetcher() : new IdentityIndexedRecordGetter());
        JoinOutputFunction.OutEmitter output = spec.isMultiOutput() ? new JoinOutputFunction.OutNEmitter() : new JoinOutputFunction.Out1Emitter();
        JoinOutputFunction join = new JoinOutputFunction(spec, mainInputAdder, lookupInputAdder, pullRecordGetter, output);
        JavaPairDStream joinedData = groupByData.mapPartitionsToPair(join);
        if (storage != null && spec.isMultiOutput()) {
            joinedData = joinedData.persist(storage);
        }
        return joinedData;
    }

    @Override
    public void build(SDF sdf, HMapSpec spec, DataFlowPipelineBuilder.Pipeline pa, Iterable<DataFlowPipelineBuilder.Pipeline> incoming) {
        int mainDataCount = 0;
        JavaPairRDD mainData = null;
        JavaPairRDD mainDataTagged = null;
        int lookupDataCount = 0;
        JavaPairRDD lookupData = null;
        JavaPairRDD lookupDataTagged = null;
        for (DataFlowPipelineBuilder.Pipeline incomingPipeline : incoming) {
            JavaPairRDD tagged;
            String inTag = incomingPipeline.getTag();
            HMapSpec.InputDef inDef = spec.getInput(inTag);
            JavaPairRDD in = ((SparkDataFlow)sdf).getIntermediatePairRDD(inTag);
            if (!((SparkDataFlow)sdf).getParameter(inTag, "retain_key", false).booleanValue()) {
                in = spec.getJoinKeySize() == 1 ? in.mapToPair(new MapPairToPairWithSingleKeyFunction(inDef.getOrder(), spec)) : (spec.getJoinKeySize() == 0 ? in.mapToPair(new MapPairToPairWithNullKeyFunction()) : in.mapToPair(new MapPairToPairWithCompositeKeyFunction(inDef.getOrder(), spec)));
            }
            if (inDef.isMain()) {
                ++mainDataCount;
                mainData = in;
                tagged = in.mapValues(new Multiplexor((byte)inDef.getOrder()));
                mainDataTagged = mainDataTagged == null ? tagged : mainDataTagged.union(tagged);
                continue;
            }
            ++lookupDataCount;
            lookupData = in;
            tagged = in.mapValues(new Multiplexor((byte)inDef.getOrder()));
            lookupDataTagged = lookupDataTagged == null ? tagged : lookupDataTagged.union(tagged);
        }
        if (mainData == null) {
            // empty if block
        }
        ((SparkDataFlow)sdf).putIntermediatePairRDD(pa.getTag(), SparkHMapJoin.buildBatchJoin(spec, spec.getJoinKeySize(), mainDataCount != 1, mainDataCount == 1 ? mainData : mainDataTagged, lookupDataCount != 1, lookupDataCount == 1 ? lookupData : lookupDataTagged, ((SparkDataFlow)sdf).getParameter(pa.getTag(), "storage_level", null)));
    }
}

