/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.common;

import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.specific.SpecificData;
import org.apache.hadoop.io.NullWritable;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.talend.bigdata.dataflow.serializer.AvroCoercionHelper;
import scala.Tuple2;

public class SparkIoDataFlowBuilderFunctions {

    public static class AvroStoreFunction<T>
    implements PairFunction<Tuple2<T, IndexedRecord>, AvroKey<IndexedRecord>, NullWritable> {
        private static final long serialVersionUID = 1L;

        public Tuple2<AvroKey<IndexedRecord>, NullWritable> call(Tuple2<T, IndexedRecord> tuple) throws Exception {
            return new Tuple2((Object)new AvroKey(tuple._2()), (Object)NullWritable.get());
        }
    }

    public static class AvroUnwrapperFunction
    implements PairFunction<Tuple2<AvroWrapper<IndexedRecord>, NullWritable>, String, IndexedRecord> {
        private static final long serialVersionUID = 1L;
        private transient Schema schema;

        public Tuple2<String, IndexedRecord> call(Tuple2<AvroWrapper<IndexedRecord>, NullWritable> tuple) throws Exception {
            if (this.schema == null) {
                this.schema = ((IndexedRecord)((AvroWrapper)tuple._1()).datum()).getSchema();
            }
            return new Tuple2((Object)this.schema.getName(), ((AvroWrapper)tuple._1()).datum());
        }
    }

    public static class AvroToFlatFunction<T>
    implements Function<Tuple2<T, IndexedRecord>, String> {
        private static final long serialVersionUID = 1L;
        private String mFieldDelimiter;
        private String mJsSchema;
        private transient Schema mSchema;

        public AvroToFlatFunction(String fieldDelimiter, Schema schema) {
            this.mFieldDelimiter = fieldDelimiter;
            this.mSchema = schema;
            this.mJsSchema = schema.toString();
        }

        public String call(Tuple2<T, IndexedRecord> in) {
            if (this.mSchema == null) {
                this.mSchema = new Schema.Parser().parse(this.mJsSchema);
            }
            String value = "";
            IndexedRecord record = (IndexedRecord)in._2();
            for (int i = 0; i < this.mSchema.getFields().size(); ++i) {
                if (value.length() != 0) {
                    value = value + this.mFieldDelimiter;
                }
                value = value + record.get(i);
            }
            return value;
        }
    }

    public static class FlatToAvroFunction
    implements PairFunction<String, String, IndexedRecord> {
        private static final long serialVersionUID = 1L;
        private String fieldDelimiter;
        private transient Schema schema;
        private String schemaStr;

        public FlatToAvroFunction(String fieldDelimiter, String schema) {
            this.fieldDelimiter = fieldDelimiter;
            this.schemaStr = schema;
        }

        public Tuple2<String, IndexedRecord> call(String line) throws Exception {
            String[] values = line.split("\\" + this.fieldDelimiter, -1);
            if (this.schema == null) {
                this.schema = new Schema.Parser().parse(this.schemaStr);
            }
            IndexedRecord record = (IndexedRecord)SpecificData.get().newRecord(null, this.schema);
            for (Schema.Field field : this.schema.getFields()) {
                record.put(field.pos(), AvroCoercionHelper.coerce(field.schema(), values[field.pos()]));
            }
            return new Tuple2((Object)this.schema.getName(), (Object)record);
        }
    }
}

