/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.common.hmap;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.talend.bigdata.dataflow.functions.FlatMapperIterator;
import org.talend.bigdata.dataflow.hmap.AvroJoiner;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.keys.JoinKeyRecord;
import scala.Tuple2;

public abstract class JoinOutputBaseFunction<KEY, OUTPUT>
implements PairFlatMapFunction<Iterator<Tuple2<JoinKeyRecord, Tuple2<Iterable<Tuple2<String, IndexedRecord>>, Iterable<Tuple2<String, IndexedRecord>>>>>, KEY, OUTPUT>,
AvroJoiner.AvroJoinEmitter<Object> {
    private static final long serialVersionUID = 1L;
    private final HMapSpec mSpec;
    private transient AvroJoiner<Object> mJoiner;
    private transient boolean mPreparedPullSources = false;
    protected JoinKeyRecord mJoinKey = null;
    protected final ArrayList<Tuple2<KEY, OUTPUT>> mOutput = new ArrayList();

    JoinOutputBaseFunction(HMapSpec spec) {
        this.mSpec = spec;
    }

    public Iterator<Tuple2<KEY, OUTPUT>> call(Iterator<Tuple2<JoinKeyRecord, Tuple2<Iterable<Tuple2<String, IndexedRecord>>, Iterable<Tuple2<String, IndexedRecord>>>>> iterator) throws Exception {
        return new FlatMapperIterator<Tuple2<JoinKeyRecord, Tuple2<Iterable<Tuple2<String, IndexedRecord>>, Iterable<Tuple2<String, IndexedRecord>>>>, Tuple2<KEY, OUTPUT>>(iterator){
            private static final long serialVersionUID = 1L;

            @Override
            public void prepare() throws Exception {
                JoinOutputBaseFunction.this.prepare();
            }

            @Override
            public Iterable<Tuple2<KEY, OUTPUT>> flatMap(Tuple2<JoinKeyRecord, Tuple2<Iterable<Tuple2<String, IndexedRecord>>, Iterable<Tuple2<String, IndexedRecord>>>> next) throws Exception {
                return JoinOutputBaseFunction.this.join((Tuple2<JoinKeyRecord, Tuple2<Iterable<Tuple2<String, IndexedRecord>>, Iterable<Tuple2<String, IndexedRecord>>>>)next);
            }

            @Override
            public void cleanup() throws Exception {
                JoinOutputBaseFunction.this.cleanup();
            }
        };
    }

    private void prepare() {
        if (this.mJoiner == null) {
            this.mJoiner = new AvroJoiner(this.mSpec);
            for (HMapSpec.OutputDef out : this.mSpec.getOutputs()) {
                this.mJoiner.addEmitter(out, this);
            }
        }
    }

    private Iterable<Tuple2<KEY, OUTPUT>> join(Tuple2<JoinKeyRecord, Tuple2<Iterable<Tuple2<String, IndexedRecord>>, Iterable<Tuple2<String, IndexedRecord>>>> t) throws Exception {
        this.mJoinKey = (JoinKeyRecord)t._1();
        this.mOutput.clear();
        this.mJoiner.reset();
        if (!this.mPreparedPullSources) {
            for (HMapSpec.InputDef pull : this.mSpec.getInputsPull()) {
                pull.getPullSource().prepare();
            }
            this.mPreparedPullSources = true;
        }
        for (HMapSpec.InputDef pull : this.mSpec.getInputsPull()) {
            for (IndexedRecord indexedRecord : pull.getPullSource().flatMap(this.mJoinKey)) {
                if (!pull.isKeptAfterFilters(indexedRecord)) continue;
                this.mJoiner.addLookup(pull, indexedRecord);
            }
        }
        for (Tuple2 lookup : (Iterable)((Tuple2)t._2())._1()) {
            this.mJoiner.addLookup(this.mSpec.getInput((String)lookup._1()), (IndexedRecord)lookup._2());
        }
        for (Tuple2 main : (Iterable)((Tuple2)t._2())._2()) {
            this.mJoiner.transformMain(main, this.mSpec.getInput((String)main._1()), (IndexedRecord)main._2());
        }
        return this.mOutput;
    }

    private void cleanup() throws Exception {
        if (this.mPreparedPullSources) {
            for (HMapSpec.InputDef pull : this.mSpec.getInputsPull()) {
                pull.getPullSource().cleanup();
            }
        }
    }
}

