/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.dataset;

import java.util.HashMap;
import java.util.Map;
import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.talend.bigdata.dataflow.DataFlow;
import org.talend.bigdata.dataflow.spark.dataset.SparkDatasetDataFlowContext;

public class SparkDatasetDataFlow
implements DataFlow<SparkDatasetDataFlowContext> {
    private final SparkDatasetDataFlowContext mContext;
    private final Map<String, Dataset<? extends IndexedRecord>> mDatasets;
    private final Map<String, Dataset<Row>> mDataFrame;
    private final Map<String, Encoder<? extends IndexedRecord>> mEncoders;

    public SparkDatasetDataFlow(SparkDatasetDataFlowContext context) {
        this.mContext = context;
        this.mDatasets = new HashMap<String, Dataset<? extends IndexedRecord>>();
        this.mDataFrame = new HashMap<String, Dataset<Row>>();
        this.mEncoders = new HashMap<String, Encoder<? extends IndexedRecord>>();
    }

    public void putDataFrame(String tag, Dataset<Row> dataset) {
        this.mDataFrame.put(tag, dataset);
    }

    public Dataset<Row> getDataFrame(String tag) {
        return this.mDataFrame.get(tag);
    }

    public void putDataset(String tag, Dataset<? extends IndexedRecord> dataset) {
        this.mDatasets.put(tag, dataset);
    }

    public void putEncoder(String tag, Encoder<? extends IndexedRecord> encoder) {
        this.mEncoders.put(tag, encoder);
    }

    public <V extends IndexedRecord> Dataset<V> getDataset(String tag) {
        return this.mDatasets.get(tag);
    }

    public <V extends IndexedRecord> Encoder<V> getEncoder(String tag) {
        return this.mEncoders.get(tag);
    }

    @Override
    public SparkDatasetDataFlowContext getContext() {
        return this.mContext;
    }

    @Override
    public void execute() {
    }
}

