/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.dataset;

import org.apache.spark.sql.SparkSession;
import org.talend.bigdata.dataflow.DataFlowContext;

public class SparkDatasetDataFlowContext
implements DataFlowContext {
    private String mJobName;
    private SparkSession mSparkSession;

    private SparkDatasetDataFlowContext(SparkSession ss, String jobName) {
        this.mSparkSession = ss;
        this.mJobName = jobName;
    }

    @Override
    public String getJobName() {
        return this.mJobName;
    }

    public SparkSession getSparkSession() {
        return this.mSparkSession;
    }

    public static class Builder {
        private String mJobName;
        private SparkSession mSparkSession;
        private String master;

        public Builder withJobName(String jobName) {
            this.mJobName = jobName;
            return this;
        }

        public Builder withSparkSession(SparkSession ss) {
            this.mSparkSession = ss;
            return this;
        }

        public Builder withMaster(String master) {
            this.master = master;
            return this;
        }

        public SparkDatasetDataFlowContext build() {
            if (this.mSparkSession == null) {
                this.mSparkSession = this.buildNewSparkSession();
            }
            return new SparkDatasetDataFlowContext(this.mSparkSession, this.mJobName);
        }

        private SparkSession buildNewSparkSession() {
            return SparkSession.builder().appName(this.mJobName).master(this.master).getOrCreate();
        }
    }
}

