/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.dataset.common.hmap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.api.java.function.MapFunction;
import org.talend.bigdata.dataflow.hmap.AvroJoiner;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.keys.IndexedRecordGetter;
import scala.Tuple2;

public class JoinOutputFunction<INPUT_MAIN, INPUT_LOOKUP, OUTPUT>
implements MapFunction<Tuple2<INPUT_MAIN, INPUT_LOOKUP>, OUTPUT> {
    private static final long serialVersionUID = 1L;
    private final HMapSpec mSpec;
    private JoinInputAdder<INPUT_MAIN> mInputMain;
    private JoinInputAdder<INPUT_LOOKUP> mInputLookup;
    private final IndexedRecordGetter<IndexedRecord> mFetcherForPullKeyExpression;
    private AvroJoiner.AvroJoinEmitter<Object> mOutputEmitter;
    private transient AvroJoiner<Object> mJoiner;
    private final List<OUTPUT> mOutput = new ArrayList<OUTPUT>();
    private boolean mPreparedPullSources = false;

    public JoinOutputFunction(HMapSpec spec, JoinInputAdder<INPUT_MAIN> inputMain, JoinInputAdder<INPUT_LOOKUP> inputLookup, IndexedRecordGetter<IndexedRecord> pullKeyFetcher, OutEmitter<OUTPUT> outputEmitter) {
        this.mSpec = spec;
        inputMain.mParent = this;
        this.mInputMain = inputMain;
        inputLookup.mParent = this;
        this.mInputLookup = inputLookup;
        outputEmitter.mParent = this;
        this.mFetcherForPullKeyExpression = pullKeyFetcher;
        this.mOutputEmitter = outputEmitter;
    }

    public OUTPUT call(Tuple2<INPUT_MAIN, INPUT_LOOKUP> inputs) throws Exception {
        this.mJoiner = new AvroJoiner(this.mSpec);
        this.mJoiner.reset();
        for (HMapSpec.OutputDef out : this.mSpec.getOutputs()) {
            this.mJoiner.addEmitter(out, this.mOutputEmitter);
        }
        this.mOutput.clear();
        Object main = inputs._1;
        Object lookup = inputs._2;
        if (!this.mPreparedPullSources) {
            for (HMapSpec.InputDef pull : this.mSpec.getInputsPull()) {
                pull.getPullSource().prepare();
            }
            this.mPreparedPullSources = true;
        }
        for (HMapSpec.InputDef pull : this.mSpec.getInputsPull()) {
            for (IndexedRecord indexedRecord : pull.getPullSource().flatMap((IndexedRecord)this.mFetcherForPullKeyExpression.get(null))) {
                if (!pull.isKeptAfterFilters(indexedRecord)) continue;
                this.mJoiner.addLookup(pull, indexedRecord);
            }
        }
        this.mInputLookup.add(lookup);
        if (this.mPreparedPullSources) {
            for (HMapSpec.InputDef pull : this.mSpec.getInputsPull()) {
                pull.getPullSource().cleanup();
            }
            this.mPreparedPullSources = false;
        }
        this.mInputMain.add(main);
        return this.mOutput.get(0);
    }

    public static class OutNEmitter
    extends OutEmitter<Tuple2<Byte, IndexedRecord>> {
        private static final long serialVersionUID = 1L;

        @Override
        public void emit(Object context, String outTag, IndexedRecord r) {
            this.mParent.mOutput.add(new Tuple2((Object)((byte)this.mParent.mSpec.getOutputOrder(outTag).intValue()), (Object)r));
        }
    }

    public static class Out1Emitter
    extends OutEmitter<IndexedRecord> {
        private static final long serialVersionUID = 1L;

        @Override
        public void emit(Object context, String outTag, IndexedRecord r) {
            this.mParent.mOutput.add(r);
        }
    }

    public static abstract class OutEmitter<OUTPUT>
    implements AvroJoiner.AvroJoinEmitter<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected JoinOutputFunction<?, ?, OUTPUT> mParent;
    }

    public static class InLookupNAdder
    extends JoinInputAdder<Tuple2<Byte, IndexedRecord>> {
        private static final long serialVersionUID = 1L;

        @Override
        public void add(Tuple2<Byte, IndexedRecord> lookup) {
            this.mParent.mJoiner.addLookup(this.mParent.mSpec.getInput(((Byte)lookup._1()).byteValue()), (IndexedRecord)lookup._2());
        }
    }

    public static class InLookup1Adder
    extends JoinInputAdder<IndexedRecord> {
        private static final long serialVersionUID = 1L;
        private transient HMapSpec.InputDef mIn;

        @Override
        public void add(IndexedRecord lookup) {
            if (this.mIn == null) {
                this.mIn = this.mParent.mSpec.getFirstInputLookup();
            }
            this.mParent.mJoiner.addLookup(this.mIn, lookup);
        }
    }

    public static class InMainNAdder
    extends JoinInputAdder<Tuple2<Byte, IndexedRecord>> {
        private static final long serialVersionUID = 1L;

        @Override
        public void add(Tuple2<Byte, IndexedRecord> main) {
            this.mParent.mJoiner.transformMain(this.mParent, this.mParent.mSpec.getInput(((Byte)main._1()).byteValue()), (IndexedRecord)main._2());
        }
    }

    public static class InMain1Adder
    extends JoinInputAdder<IndexedRecord> {
        private static final long serialVersionUID = 1L;
        private transient HMapSpec.InputDef mIn;

        @Override
        public void add(IndexedRecord main) {
            if (this.mIn == null) {
                this.mIn = this.mParent.mSpec.getFirstInputMain();
            }
            this.mParent.mJoiner.transformMain(this.mParent, this.mIn, main);
        }
    }

    public static abstract class JoinInputAdder<INPUT>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected JoinOutputFunction<?, ?, ?> mParent;

        abstract void add(INPUT var1);
    }
}

