/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.dataset.hmap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;
import org.talend.bigdata.dataflow.DataFlowPipelineBuilder;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.keys.ZeroJoinKeyIndexedRecordFetcher;
import org.talend.bigdata.dataflow.spark.dataset.SparkDatasetDataFlow;
import org.talend.bigdata.dataflow.spark.dataset.common.hmap.JoinOutputFunction;
import scala.Tuple2;

public class SparkDatasetHMapJoin
implements DataFlowPipelineBuilder.PipelinePartialBuilder<SparkDatasetDataFlow, HMapSpec> {
    Dataset<? extends IndexedRecord> mainDataset = null;
    Dataset<? extends IndexedRecord> lookupDataset = null;
    HMapSpec.InputDef mainInputDef = null;
    HMapSpec.InputDef lookupInputDef = null;
    SparkDatasetDataFlow dataFlow;

    @Override
    public void build(SparkDatasetDataFlow sddf, HMapSpec hMapSpec, DataFlowPipelineBuilder.Pipeline pa, Iterable<DataFlowPipelineBuilder.Pipeline> incoming) {
        boolean hasAJoinKey;
        int mainCount = 0;
        int lookupCount = 0;
        this.dataFlow = sddf;
        HMapSpec.OutputDef outputDef = hMapSpec.getOutputs().iterator().next();
        for (DataFlowPipelineBuilder.Pipeline inputFlow : incoming) {
            String inputFlowTag = inputFlow.getTag();
            HMapSpec.InputDef inputFlowDef = hMapSpec.getInput(inputFlowTag);
            if (inputFlowDef.isMain()) {
                ++mainCount;
                this.mainDataset = sddf.getDataset(inputFlowTag);
                this.mainInputDef = inputFlowDef;
                continue;
            }
            if (!inputFlowDef.isLookup()) continue;
            ++lookupCount;
            this.lookupDataset = sddf.getDataset(inputFlowTag);
            this.lookupInputDef = inputFlowDef;
        }
        boolean bl = hasAJoinKey = hMapSpec.getJoinKeySize() >= 1 || hMapSpec.useCustomJoinExpression();
        if (!hMapSpec.isMultiOutput() && mainCount == 1 && lookupCount == 1 && !hasAJoinKey) {
            Dataset outputDataset = this.mainDataset.crossJoin(this.lookupDataset);
            sddf.putDataFrame(outputDef.getTag(), (Dataset<Row>)outputDataset);
        } else if (!hMapSpec.isMultiOutput() && mainCount == 1 && lookupCount == 1 && hasAJoinKey) {
            Column joinCondition;
            String joinType = this.convertJoinTypeToString(this.lookupInputDef.getJoin().getJoinType());
            String[] joinColumns = this.lookupInputDef.getJoin().getKeysNames();
            if (!this.lookupInputDef.getJoin().useCustomJoinExpression()) {
                joinCondition = this.mainDataset.col(this.mainInputDef.getJoin().getKeys()[0].getName());
                joinCondition = joinCondition.equalTo((Object)this.lookupDataset.col(this.lookupInputDef.getJoin().getKeys()[0].getName()));
                for (int joinKeyIndex = 1; joinKeyIndex < hMapSpec.getJoinKeySize(); ++joinKeyIndex) {
                    joinCondition = joinCondition.and(this.mainDataset.col(this.mainInputDef.getJoin().getKeys()[joinKeyIndex].getName()).equalTo((Object)this.lookupDataset.col(this.lookupInputDef.getJoin().getKeys()[joinKeyIndex].getName())));
                    joinColumns[joinKeyIndex] = this.lookupInputDef.getJoin().getKeys()[joinKeyIndex].getName();
                }
            } else {
                joinCondition = this.buildCustomJoinCondition(this.lookupInputDef.getJoin().getCustomJoinExpression());
            }
            if (this.lookupInputDef.getJoin().getJoinMatchType().equals((Object)HMapSpec.JoinMatchType.UNIQUE)) {
                this.lookupDataset = this.lookupDataset.dropDuplicates(joinColumns);
            }
            JoinOutputFunction.JoinInputAdder mainInputAdder = mainCount > 1 ? new JoinOutputFunction.InMainNAdder() : new JoinOutputFunction.InMain1Adder();
            JoinOutputFunction.JoinInputAdder lookupInputAdder = lookupCount > 1 ? new JoinOutputFunction.InLookupNAdder() : new JoinOutputFunction.InLookup1Adder();
            ZeroJoinKeyIndexedRecordFetcher<IndexedRecord> pullRecordGetter = new ZeroJoinKeyIndexedRecordFetcher<IndexedRecord>();
            JoinOutputFunction.OutEmitter output = hMapSpec.isMultiOutput() ? new JoinOutputFunction.OutNEmitter() : new JoinOutputFunction.Out1Emitter();
            JoinOutputFunction<Tuple2<Byte, IndexedRecord>, Tuple2<Byte, IndexedRecord>, Tuple2<Byte, IndexedRecord>> join = new JoinOutputFunction<Tuple2<Byte, IndexedRecord>, Tuple2<Byte, IndexedRecord>, Tuple2<Byte, IndexedRecord>>(hMapSpec, mainInputAdder, lookupInputAdder, pullRecordGetter, output);
            if (hMapSpec.shouldBroadcastCondition().booleanValue()) {
                Dataset outputDataset = this.mainDataset.joinWith(functions.broadcast(this.lookupDataset), joinCondition, joinType).map(join, sddf.getEncoder(outputDef.getTag()));
                sddf.putDataset(outputDef.getTag(), (Dataset<? extends IndexedRecord>)outputDataset);
            } else {
                Dataset outputDataset = this.mainDataset.joinWith(this.lookupDataset, joinCondition, joinType).map(join, sddf.getEncoder(outputDef.getTag()));
                sddf.putDataset(outputDef.getTag(), (Dataset<? extends IndexedRecord>)outputDataset);
            }
        }
    }

    private Column buildCustomJoinCondition(String customJoinExpression) {
        Column resultCondition;
        Matcher complexExprMatcher = Pattern.compile("(?<left>[^&\\|]+)(?<operator>&&|\\|\\|)(?<right>[^&\\|]+.*)").matcher(customJoinExpression);
        if (complexExprMatcher.matches()) {
            String leftTerm = complexExprMatcher.group("left");
            String operator = complexExprMatcher.group("operator");
            String rightTerm = complexExprMatcher.group("right");
            resultCondition = "||".equals(operator) ? this.buildCustomJoinCondition(leftTerm).or(this.buildCustomJoinCondition(rightTerm)) : this.buildCustomJoinCondition(leftTerm).and(this.buildCustomJoinCondition(rightTerm));
        } else {
            Matcher simpleExprMatcher = Pattern.compile("\\s*(?<mainds>\\w+)(\\.)(?<maincol>\\w+)\\s*(?<operator>[<>=]+)\\s*(?<lookupds>\\w+)(\\.)(?<lookupcol>\\w+)\\s*").matcher(customJoinExpression);
            if (!simpleExprMatcher.matches()) {
                throw new RuntimeException("Bad or unsupported expression syntax for :" + customJoinExpression);
            }
            String mainDatasetName = simpleExprMatcher.group("mainds");
            String lookupDatasetName = simpleExprMatcher.group("lookupds");
            String mainColName = simpleExprMatcher.group("maincol");
            String lookupColName = simpleExprMatcher.group("lookupcol");
            String operator = simpleExprMatcher.group("operator");
            Dataset mainDataset = this.dataFlow.getDataset(mainDatasetName);
            Dataset lookupDataset = this.dataFlow.getDataset(lookupDatasetName);
            Column leftColumn = mainDataset.col(mainColName);
            Column rightColumn = lookupDataset.col(lookupColName);
            switch (operator) {
                case "<": {
                    resultCondition = leftColumn.lt((Object)rightColumn);
                    break;
                }
                case ">": {
                    resultCondition = leftColumn.gt((Object)rightColumn);
                    break;
                }
                case "<=": {
                    resultCondition = leftColumn.leq((Object)rightColumn);
                    break;
                }
                case ">=": {
                    resultCondition = leftColumn.geq((Object)rightColumn);
                    break;
                }
                default: {
                    resultCondition = leftColumn.equalTo((Object)rightColumn);
                }
            }
        }
        return resultCondition;
    }

    private String convertJoinTypeToString(HMapSpec.JoinType joinType) {
        String res = "";
        if (HMapSpec.JoinType.INNER.equals((Object)joinType)) {
            res = "inner";
        } else if (HMapSpec.JoinType.LEFT_OUTER.equals((Object)joinType)) {
            res = "left_outer";
        }
        return res;
    }
}

