/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.main;

import java.io.IOException;
import org.apache.avro.Schema;
import org.talend.bigdata.dataflow.SpecException;
import org.talend.bigdata.dataflow.hmap.HMap;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.io.Io;
import org.talend.bigdata.dataflow.io.IoSpec;
import org.talend.bigdata.dataflow.spark.batch.SparkBatchDataFlow;
import org.talend.bigdata.dataflow.spark.batch.SparkBatchDataFlowContext;

public class EnrichedOrderSparkTask {
    public static void main(String[] args) {
        new EnrichedOrderSparkTask().run(args[0], args[1]);
    }

    private void run(String in, String out) {
        Schema oSchema = null;
        Schema liSchema = null;
        Schema eoSchema = null;
        try {
            Schema.Parser parser = new Schema.Parser();
            oSchema = parser.parse(this.getClass().getResourceAsStream("/oSchema.avsc"));
            liSchema = parser.parse(this.getClass().getResourceAsStream("/liSchema.avsc"));
            eoSchema = parser.parse(this.getClass().getResourceAsStream("/orders_hierarchy.avsc"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Io io = new Io();
        HMap hmap = new HMap();
        IoSpec oIoSpec = null;
        IoSpec liIoSpec = null;
        IoSpec eoIoSpec = null;
        HMapSpec hmapSpec = null;
        try {
            oIoSpec = io.createSpecBuilder().flatInput("o", oSchema, in + "/orders/", "|", "\n").build();
            liIoSpec = io.createSpecBuilder().flatInput("li", liSchema, in + "/lineitem/", "|", "\n").build();
            hmapSpec = hmap.createSpecBuilder().declareInput("o", oSchema).declareInput("li", liSchema).declareOutput("eo", eoSchema, new HMapSpec.OutputType[0]).map("o.o_orderkey", "eo.orderkey").map("o.o_custkey", "eo.custkey").map("o.o_orderstatus", "eo.orderstatus").map("o.o_totalprice", "eo.totalprice").map("o.o_orderdate", "eo.orderdate").map("o.o_orderpriority", "eo.orderpriority").map("o.o_clerk", "eo.clerk").map("o.o_shippriority", "eo.shippriority").map("o.o_comment", "eo.comment").map("li.li_partkey", "eo.lineitems.partkey").map("li.li_suppkey", "eo.lineitems.suppkey").map("li.li_linenumber", "eo.lineitems.linenumber").map("li.li_quantity", "eo.lineitems.quantity").map("li.li_extendedprice", "eo.lineitems.extendedprice").map("li.li_discount", "eo.lineitems.discount").map("li.li_tax", "eo.lineitems.tax").map("li.li_returnflag", "eo.lineitems.returnflag").map("li.li_linestatus", "eo.lineitems.linestatus").map("li.li_shipdate", "eo.lineitems.shipdate").map("li.li_commitdate", "eo.lineitems.commitdate").map("li.li_receiptdate", "eo.lineitems.receiptdate").map("li.li_shipinstruct", "eo.lineitems.shipinstruct").map("li.li_shipmode", "eo.lineitems.shipmode").map("li.li_comment", "eo.lineitems.comment").joinKey("o", HMapSpec.JoinType.MAIN, HMapSpec.JoinMatchType.ALL, "o.o_orderkey").joinKey("li", HMapSpec.JoinType.NESTED, HMapSpec.JoinMatchType.ALL, "li.li_orderkey").build();
            eoIoSpec = io.createSpecBuilder().avroOutput("eo", eoSchema, out).build();
        }
        catch (SpecException e) {
            throw new RuntimeException(e);
        }
        SparkBatchDataFlowContext context = new SparkBatchDataFlowContext.Builder().withJobName("EnrichedOrderSparkTask").build();
        SparkBatchDataFlow df = new SparkBatchDataFlow(context);
        io.createDataFlowBuilder(oIoSpec).build(df);
        io.createDataFlowBuilder(liIoSpec).build(df);
        hmap.createDataFlowBuilder(hmapSpec).build(df);
        io.createDataFlowBuilder(eoIoSpec).build(df);
        df.execute();
    }
}

