/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.spark.streaming.hmap;

import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.talend.bigdata.dataflow.DataFlowPipelineBuilder;
import org.talend.bigdata.dataflow.hmap.HMapSpec;
import org.talend.bigdata.dataflow.spark.common.hmap.MapPairToPairWithCompositeKeyFunction;
import org.talend.bigdata.dataflow.spark.common.hmap.TransformOutputMultiFunction;
import org.talend.bigdata.dataflow.spark.common.hmap.TransformOutputSingleFunction;
import org.talend.bigdata.dataflow.spark.streaming.SparkStreamingDataFlow;

public class SparkHMapTransform
extends org.talend.bigdata.dataflow.spark.batch.hmap.SparkHMapTransform<SparkStreamingDataFlow> {
    @Override
    public void build(SparkStreamingDataFlow sdf, HMapSpec spec, DataFlowPipelineBuilder.Pipeline pa, Iterable<DataFlowPipelineBuilder.Pipeline> incoming) {
        HMapSpec.InputDef inDef = spec.getFirstInputNonPull();
        if (null == sdf.getIntermediatePairDStream(inDef.getTag())) {
            super.build(sdf, spec, pa, incoming);
        } else {
            JavaPairDStream inData = sdf.getIntermediatePairDStream(inDef.getTag());
            if (null != inDef.getJoin() && !sdf.getParameter(inDef.getTag(), "retain_key", false).booleanValue()) {
                inData = inData.mapToPair(new MapPairToPairWithCompositeKeyFunction(inDef.getOrder(), spec));
            }
            if (spec.isMultiOutput()) {
                JavaPairDStream outData = inData.mapPartitionsToPair(new TransformOutputMultiFunction(spec));
                sdf.putIntermediatePairDStream(pa.getTag(), outData);
            } else {
                JavaPairDStream outData = inData.mapPartitionsToPair(new TransformOutputSingleFunction(spec));
                sdf.putIntermediatePairDStream(pa.getTag(), outData);
            }
        }
    }
}

