/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow;

import java.util.HashMap;
import java.util.Iterator;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.talend.bigdata.dataflow.DataFlow;
import org.talend.bigdata.dataflow.DataFlowBuilder;

public abstract class DataFlowPipelineBuilder
extends DataFlowBuilder
implements Iterable<Pipeline> {
    DirectedAcyclicGraph<Pipeline, Object> mActions = new DirectedAcyclicGraph(Object.class);

    protected void add(Pipeline p) {
        this.mActions.addVertex(p);
    }

    protected void addFrom(Pipeline src, Pipeline ... dsts) {
        this.mActions.addVertex(src);
        for (Pipeline dst : dsts) {
            this.mActions.addVertex(dst);
            this.mActions.addEdge(src, dst);
        }
    }

    protected void addTo(Pipeline dst, Pipeline ... srcs) {
        this.mActions.addVertex(dst);
        for (Pipeline src : srcs) {
            this.mActions.addVertex(src);
            this.mActions.addEdge(src, dst);
        }
    }

    @Override
    public Iterator<Pipeline> iterator() {
        return this.mActions.iterator();
    }

    private final class IncomingPipelineIterable
    implements Iterable<Pipeline> {
        private final Iterable<Object> mEdgeIterable;

        public IncomingPipelineIterable(Pipeline pa) {
            this.mEdgeIterable = DataFlowPipelineBuilder.this.mActions.incomingEdgesOf(pa);
        }

        @Override
        public Iterator<Pipeline> iterator() {
            return new Iterator<Pipeline>(){
                Iterator<Object> mEdgeIterator;
                {
                    this.mEdgeIterator = IncomingPipelineIterable.this.mEdgeIterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.mEdgeIterator.hasNext();
                }

                @Override
                public Pipeline next() {
                    return (Pipeline)DataFlowPipelineBuilder.this.mActions.getEdgeSource(this.mEdgeIterator.next());
                }

                @Override
                public void remove() {
                    this.mEdgeIterator.remove();
                }
            };
        }
    }

    public static class PipelineFactory<DATAFLOW extends DataFlow<?>, SPEC>
    extends HashMap<Class<? extends Pipeline>, PipelinePartialBuilder<DATAFLOW, SPEC>> {
        private static final long serialVersionUID = 1L;

        public void buildPipelines(DATAFLOW df, SPEC spec, DataFlowPipelineBuilder dfpb) {
            for (Pipeline pa : dfpb) {
                PipelinePartialBuilder build = (PipelinePartialBuilder)this.get(pa.getClass());
                DataFlowPipelineBuilder dataFlowPipelineBuilder = dfpb;
                dataFlowPipelineBuilder.getClass();
                build.build(df, spec, pa, dataFlowPipelineBuilder.new IncomingPipelineIterable(pa));
            }
        }
    }

    public static interface PipelinePartialBuilder<DATAFLOW extends DataFlow<?>, SPEC> {
        public void build(DATAFLOW var1, SPEC var2, Pipeline var3, Iterable<Pipeline> var4);
    }

    public static abstract class Pipeline {
        private final String mTag;

        public Pipeline(String tag) {
            this.mTag = tag;
        }

        public String getTag() {
            return this.mTag;
        }
    }
}

