/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.functions;

import java.util.Iterator;
import org.talend.bigdata.dataflow.functions.Mapper;

public abstract class MapperIterator<IN, OUT>
implements Mapper<IN, OUT>,
Iterator<OUT> {
    private boolean mInitialized = false;
    private final Iterator<IN> mWrapped;

    public MapperIterator(Iterator<IN> wrapped) {
        this.mWrapped = wrapped;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.mWrapped.hasNext();
        try {
            if (hasNext && !this.mInitialized) {
                this.prepare();
                this.mInitialized = true;
            } else if (this.mInitialized) {
                this.cleanup();
                this.mInitialized = false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.mWrapped.hasNext();
    }

    @Override
    public OUT next() {
        try {
            return this.map(this.mWrapped.next());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        this.mWrapped.remove();
    }
}

