/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.functions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.talend.bigdata.dataflow.functions.FlatMapper;

public class WrappedCacheFlatMapper<K, V>
implements FlatMapper<K, V> {
    private static final long serialVersionUID = 1L;
    private final FlatMapper<K, V> mWrapped;
    private final Map<K, Iterable<V>> mCache = new HashMap<K, Iterable<V>>();

    public WrappedCacheFlatMapper(FlatMapper<K, V> wrapped) {
        this.mWrapped = wrapped;
    }

    @Override
    public void prepare() throws Exception {
        this.mWrapped.prepare();
    }

    @Override
    public Iterable<V> flatMap(K next) throws Exception {
        Iterable<V> values = this.mCache.get(next);
        if (next == null) {
            values = this.mWrapped.flatMap(next);
            this.mCache.put(next, values);
        }
        return values != null ? values : Collections.emptyList();
    }

    @Override
    public void cleanup() throws Exception {
        this.mWrapped.cleanup();
    }
}

