/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hexpr;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.IndexedRecord;
import org.talend.bigdata.dataflow.hexpr.AvroObjectTraverser;
import org.talend.bigdata.dataflow.hexpr.HExpr;

public class AvroGetter
extends AvroObjectTraverser {
    private final HashMap<HExpr, Iterator<?>> mIterators = new HashMap();

    public AvroGetter(String tag, Schema schema) {
        super(tag, schema);
    }

    @Override
    public void reset() {
        super.reset();
        this.mIterators.clear();
    }

    @Override
    protected void reset(HExpr expr) {
        super.reset(expr);
        String fq = expr.getFullyQualifiedName();
        Iterator<HExpr> i = this.mIterators.keySet().iterator();
        while (i.hasNext()) {
            HExpr toTest = i.next();
            if (expr == toTest || !toTest.getFullyQualifiedName().startsWith(fq)) continue;
            i.remove();
        }
    }

    private Iterator<?> getCurrentIterator(HExpr expr) {
        Iterator i = this.mIterators.get(expr);
        if (i == null) {
            GenericArray container = (GenericArray)this.get(expr);
            i = container.iterator();
            this.mIterators.put(expr, i);
        }
        return i;
    }

    public boolean hasNext(HExpr expr) {
        if (!expr.isArray()) {
            return false;
        }
        return this.getCurrentIterator(expr).hasNext();
    }

    public Object next(HExpr expr) {
        if (!expr.isArray()) {
            return false;
        }
        this.reset(expr);
        Object current = this.getCurrentIterator(expr).next();
        this.setInternalNext(expr, current);
        return current;
    }

    public void setRootValue(IndexedRecord record) {
        this.setRootValueInternal(record);
    }

    @Override
    protected List<?> handleUnknownArray(HExpr exprParent, HExpr expr) {
        throw new IllegalStateException("Missing next() call on parent iterator :" + exprParent);
    }

    @Override
    protected IndexedRecord handleUnknownRecord(HExpr exprParent, HExpr expr) {
        throw new IllegalStateException("Missing next() call on parent iterator :" + exprParent);
    }

    @Override
    protected Object handleUnknownData(HExpr exprParent, HExpr expr) {
        return null;
    }
}

