/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hexpr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.commons.collections.IteratorUtils;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hexpr.HTree;

public abstract class AvroObjectTraverser
implements Iterable<HExpr> {
    protected final HTree mTree;
    private final HashMap<HExpr, Object> mData = new HashMap();
    private final HashMap<HExpr, IndexedRecord> mRecords = new HashMap();
    private final HashMap<HExpr, List<?>> mArrays = new HashMap();

    public AvroObjectTraverser(String tag, Schema schema) {
        this.mTree = new HTree(tag, schema);
    }

    @Override
    public Iterator<HExpr> iterator() {
        return this.mTree.iterator();
    }

    public void reset() {
        this.mArrays.clear();
        this.mData.clear();
        this.mRecords.clear();
    }

    protected void reset(HExpr expr) {
        String fq = expr.getFullyQualifiedName();
        Iterator i = IteratorUtils.chainedIterator(Arrays.asList(this.mArrays.keySet().iterator(), this.mRecords.keySet().iterator(), this.mData.keySet().iterator()));
        while (i.hasNext()) {
            HExpr cached = (HExpr)i.next();
            if (!cached.getFullyQualifiedName().startsWith(fq) || cached == expr) continue;
            i.remove();
        }
    }

    public Schema getRootSchema() {
        return this.mTree.getRootSchema();
    }

    public HExpr getRootHExpr() {
        return this.mTree.getExpression(this.mTree.getRootTag());
    }

    public Object get(String accessor) {
        return this.get(this.mTree.getExpression(accessor));
    }

    public HExpr getHExpr(String accessor) {
        return this.mTree.getExpression(accessor);
    }

    public IndexedRecord getRootValue() {
        return this.mRecords.get(this.getRootHExpr());
    }

    protected void setRootValueInternal(IndexedRecord record) {
        this.reset();
        this.mRecords.put(this.getRootHExpr(), record);
    }

    protected void setInternalNext(HExpr expr, Object value) {
        HExpr child = this.mTree.getChildren(expr).get(0);
        if (value instanceof IndexedRecord) {
            this.mRecords.put(child, (IndexedRecord)value);
        } else {
            this.mData.put(child, value);
        }
    }

    public Object get(HExpr expr) {
        HExpr exprParent = expr.getParent();
        if (exprParent == null) {
            return this.getRootValue();
        }
        if (expr.isArray()) {
            List<?> array = this.mArrays.get(expr);
            if (array != null) {
                return array;
            }
            String fieldName = expr.getName();
            if (!exprParent.isRecord() || fieldName == null) {
                throw new UnsupportedOperationException("TODO: can't fetch " + expr.getClass().getSimpleName() + "[" + expr.getName() + "] from parent " + exprParent.getClass().getSimpleName());
            }
            IndexedRecord container = (IndexedRecord)this.get(exprParent);
            array = (List<?>)container.get(exprParent.getSchema().getField(fieldName).pos());
            if (array == null) {
                array = this.handleUnknownArray(exprParent, expr);
            }
            this.mArrays.put(expr, array);
            return array;
        }
        if (expr.isRecord()) {
            IndexedRecord record = this.mRecords.get(expr);
            if (record != null) {
                return record;
            }
            String fieldName = expr.getName();
            if (exprParent.isRecord() && fieldName != null) {
                IndexedRecord container = (IndexedRecord)this.get(exprParent);
                record = (IndexedRecord)container.get(exprParent.getSchema().getField(expr.getName()).pos());
            } else if (!exprParent.isArray()) {
                throw new UnsupportedOperationException("TODO: can't fetch " + expr.getClass().getSimpleName() + "[" + expr.getName() + "] from parent " + exprParent.getClass().getSimpleName());
            }
            if (record == null) {
                record = this.handleUnknownRecord(exprParent, expr);
            }
            this.mRecords.put(expr, record);
            return record;
        }
        Object data = this.mData.get(expr);
        if (data != null) {
            return data;
        }
        String fieldName = expr.getName();
        if (exprParent.isRecord() && fieldName != null) {
            IndexedRecord container = (IndexedRecord)this.get(exprParent);
            data = container.get(exprParent.getSchema().getField(fieldName).pos());
        } else if (!exprParent.isArray()) {
            throw new UnsupportedOperationException("TODO: can't fetch " + expr.getClass().getSimpleName() + "[" + expr.getName() + "] from parent " + exprParent.getClass().getSimpleName());
        }
        if (data == null) {
            data = this.handleUnknownData(exprParent, expr);
        }
        this.mData.put(expr, data);
        return data;
    }

    protected abstract List<?> handleUnknownArray(HExpr var1, HExpr var2);

    protected abstract IndexedRecord handleUnknownRecord(HExpr var1, HExpr var2);

    protected abstract Object handleUnknownData(HExpr var1, HExpr var2);

    public String toString() {
        return this.getRootHExpr() + ": " + String.valueOf(this.getRootValue());
    }
}

