/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.dataflow.hexpr;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.talend.bigdata.dataflow.hexpr.AvroObjectTraverser;
import org.talend.bigdata.dataflow.hexpr.HExpr;
import org.talend.bigdata.dataflow.hexpr.HExprRecord;

public class AvroSetter
extends AvroObjectTraverser {
    public AvroSetter(String tag, Schema schema) {
        super(tag, schema);
    }

    protected void setInternal(HExpr expr, Object value) {
        HExpr exprParent = expr.getParent();
        if (exprParent == null) {
            this.setRootValueInternal((IndexedRecord)value);
            return;
        }
        String fieldName = expr.getName();
        if (exprParent.isRecord() && fieldName != null) {
            IndexedRecord container = (IndexedRecord)this.get(exprParent);
            container.put(exprParent.getSchema().getField(fieldName).pos(), this.convert(expr, value));
        } else if (exprParent.isArray()) {
            List container = (List)this.get(exprParent);
            if (container == null) {
                throw new IllegalStateException("Parent arrays must be created before using: " + exprParent);
            }
        } else {
            throw new UnsupportedOperationException("TODO: can't set " + expr.getClass().getSimpleName() + "[" + expr.getName() + "] from parent " + exprParent.getClass().getSimpleName());
        }
    }

    private Object convert(HExpr expr, Object value) {
        if (value instanceof Utf8) {
            return value.toString();
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void create(HExpr expr) {
        if (expr.isArray()) {
            List container = (List)this.get(expr);
            this.reset(expr);
            HExpr exprChild = this.mTree.getChildren(expr).get(0);
            if (!exprChild.isRecord()) throw new IllegalStateException("Arrays can only hold records.");
            IndexedRecord record = ((HExprRecord)exprChild).createEmptyRecord();
            container.add(record);
            this.setInternalNext(expr, record);
            return;
        } else {
            if (expr.getParent() != null) throw new IllegalStateException("Create should never be called on a non-array type.");
            if (this.getRootValue() != null) return;
            this.setRootValueInternal(((HExprRecord)expr).createEmptyRecord());
        }
    }

    @Override
    public Object get(HExpr expr) {
        Object value = super.get(expr);
        if (expr.isRecord() && value == null) {
            value = ((HExprRecord)expr).createEmptyRecord();
            this.setInternal(expr, value);
        }
        return value;
    }

    public void set(HExpr expr, Object value) {
        if (!expr.isPrimitive()) {
            throw new IllegalStateException("Only set primitives.");
        }
        this.setInternal(expr, value);
    }

    @Override
    protected List<?> handleUnknownArray(HExpr exprParent, HExpr expr) {
        if (exprParent.isRecord()) {
            GenericData.Array array = new GenericData.Array(0, expr.getSchema());
            IndexedRecord container = (IndexedRecord)this.get(exprParent);
            container.put(exprParent.getSchema().getField(expr.getName()).pos(), (Object)array);
            return array;
        }
        return null;
    }

    @Override
    protected IndexedRecord handleUnknownRecord(HExpr exprParent, HExpr expr) {
        if (exprParent.isRecord()) {
            IndexedRecord record = ((HExprRecord)expr).createEmptyRecord();
            IndexedRecord container = (IndexedRecord)this.get(exprParent);
            container.put(exprParent.getSchema().getField(expr.getName()).pos(), (Object)record);
            return record;
        }
        return null;
    }

    @Override
    protected Object handleUnknownData(HExpr exprParent, HExpr expr) {
        return null;
    }
}

